///////////////////////////////////////////////////////
//
// FileName: i2ctest.c
// Author: kwanjee@andrew.cmu.edu
//
// I2C testing program
//
////////////////////////////////////////////////////////

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "i2cs.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define I2C_PREFIX 0xf8

char buf[10];
char bufptr;
char bufcnt;
char i2c_addr;

void main(void) {
	char nack;
	char inp, num, i;
	char state = 0;

	TRISB = 0;
	RBPU = 0; // pullups on port b
	PORTB = 0x07;
	TRISB = 0x07; // B0-2 as inputs

	i2c_addr = (~PORTB) & 0x07;
	i2c_addr |= I2C_PREFIX;
    
	// init...
	ser_init(SER_115200); // init rs-232 comms
	i2c_init(i2c_addr); // i2c slave

	putstring("\rI2C echo\r");
	puthex(i2c_addr);
	
	while (1) {
		inp = i2c_rx();
		
		switch (inp) {
		case I2C_SLAVE_READ: // called
				bufcnt = 0;
				break;
		case I2C_DATA_READ: // new data
				buf[bufcnt++] = i2c_data;
				//putdec(i2c_data);
				//ser_tx(' ');
				break;
		case I2C_SLAVE_WRITE: // write data
				//putstring("tx: ");
				i2c_tx(bufcnt);
				//putdec(bufcnt);
				for (i=0; i<bufcnt; i++) {
					//ser_tx(' ');
					i2c_tx(buf[i]);
					//putdec(buf[i]);
				}
				break;
		}
	}
}

