///////////////////////////////////////////////////////
//
// FileName: sui.c
// Author: kwanjee@andrew.cmu.edu
//
// Serial user interface (implementing v0.2)
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

char buf[50];

void main(void) {
	char inp, num;
	char i, j;
	char _cantrig;
	#bit cantrig = _cantrig.0

	TSB3 = 0;
	TSB2 = 0; // RB2 as output
	RB2 = 0;
	TSB1 = 0;
	RB1 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	GIE = 1;

	inp = read_eeprom(TO_ADDR);
	if (inp != 255) to_val = inp;
	

	i=0;
/*	while (1) {
		my_putc('!');
		inp = my_getc();
		buf[i++] = inp;
		if (inp == '\r') {
			// tx
			if (i > 1) {
				for (j=0; j<i; j++) {
					ser_tx(buf[j]);
				}
			}
			// rx
			i=0; inp = 0;
			while (inp != '\r') {
				inp = ser_rx();
				buf[i++] = inp;
				// echo
				if (inp = '\r') {
					for (j=0; j<i; j++) {
						my_putc(buf[j]);
					}
				}
			}
		}
	}*/
	
	TSB0 = 1;
	cantrig = 1;
	i=0;
	
	while (1) {
		if (cantrig && !RB0) {
			/*ser_tx('\r');
			inp = 0;
			while (inp != ':') {
				inp = ser_rx();
				buf[i++] = inp;
			}
			for (j=0; j<i; j++) {
				my_putc(buf[j]);
			}
			i=0;*/

			ser_tx("gm\r");
			cantrig = 0;
		}
		if (RB0 && !cantrig) {
			cantrig = 1;
		}
		if (RCIF) {
			inp = ser_rx();
			buf[i++] = inp;
			// echo
			if (inp == '\r') {
				for (j=0; j<i; j++) {
					my_putc(buf[j]);
				}
				i=0;
			}
		}
	}
	
/*	
	while (1) {
		i=0; inp = 0;
		while (inp != '\r') {
			inp = ser_rx();
			buf[i++] = inp;
		}
		if (i > 1) {
			for (j=0; j<i; j++) {
				my_putc(buf[j]);
			}
		}
	}
*/
}

