///////////////////////////////////////////////////////
//
// FileName: sui.c
// Author: kwanjee@andrew.cmu.edu
//
// Serial user interface (implementing v0.2)
//
////////////////////////////////////////////////////////

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

#define CENTERX 40
#define SERVOX	7

char inbuf[30];
char bp;

// camera parameters
char xpos;
char pxpos;
char size;
signed char dx;

char get_objx(void) {
	char inp, i;
	unsigned char x1, x2, x;
	
	bp = 0;
	// wait for delimiter
	do {
		while (ser_rx() != 255);
	} while (ser_rx() != 'C');
	
	for (bp=0; bp<6; bp++) {
		inbuf[bp] = ser_rx();
	}
			
	// interpret packet
	x1 = inbuf[0];
	x2 = inbuf[2];
	size = inbuf[4];
	
	//putdec(x1); my_putc(' ');
	//putdec(x2); my_putc(' ');

	//x = ((long)x1 + (long)x2) >> 1;
	x1 = x1 >> 1;
	x2 = x2 >> 1;
	x = x1 + x2;
	
	//putdec(x); my_putc(' ');
	
	return x;
}

void move_camera(char x) {
	
	if (x == 0) {
/*		if (dx > 0) {
			xpos = xpos + 10;
		}
		else {
			xpos = xpos - 10;
		}
		if (xpos > 245) dx = 0;
		if (xpos < 10) dx = 1;*/
		return;
	}
	else {
		dx = CENTERX - x;
		//putdec(dx);
		pxpos = xpos;
		
		if (abs(dx) < 5) return;
		
		//if (x < CENTERX) {
		if (dx > 0) {
			// dx > 0
			xpos = xpos - (dx/2);
			
			// xpos decreases -> dx negative
			// x < CENTERX -> dx = x - CENTERX
	
			// dx is negative, it should decrease
			if (xpos > pxpos) xpos = 1; // saturate
		}
		//else if (x > CENTERX) {
		else if (dx < 0) {
			// dx < 0
			//dx = abs(dx);
			xpos = xpos + (abs(dx)/2);
			
			// dx is positive, it should increase
			if (xpos < pxpos) xpos = 255; // saturate
		}
	}
	
	servo_pos[SERVOX] = xpos;

	return;
}

// campos == 115 when centered
char turn_body(char campos) {
	if (campos > 120) {
		// camera facing left
		// turn left
		pwm_setvel8(0,1,150);
		pwm_setvel8(1,0,150);		
		return 1;
	}
	else if (campos < 110) {
		// camera facing right
		// turn right
		pwm_setvel8(0,0,150);
		pwm_setvel8(1,1,150);
		return 1;
	}
	else {
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
		return 0;
	}
}

void move_body(char size) {
	if (size < 20) {
		// too small, ignore
		return;
	}
	else if (size < 40) {
		// too far, move towards
		pwm_setvel8(0,1,150);
		pwm_setvel8(1,1,150);		
	}
	else if (size > 100) {
		// too far, move towards
		pwm_setvel8(0,0,150);
		pwm_setvel8(1,0,150);		
	}
	else {
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
	}		
}

void main(void) {
	char inp, num, x;
	char turning;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	servo_init();
	pwm_init();

	servo_state = 1; // activate servo driver

	GIE = 1;

	my_putc("1 dof tracker\r");

	xpos = 115;
	servo_pos[SERVOX] = xpos;

	//my_getc();

	do {
		ser_tx('\r');
		delay_ms(100);
		ser_tx("rm 1\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');
	my_putc('~');

	do {
		ser_tx('\r');
		while (ser_rx() != ':');
		ser_tx("tc 200 255 0 30 0 30\r");
		//ser_tx("tw\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != '\r');
	} while (inp != 'A');
	my_putc('!');
		
	while (1) {
		x = get_objx();
		move_camera(x);
		turning = turn_body(xpos);
		if (!turning) move_body(size);
	}
		

	/*while (1) {
		x = getdec();
		//turn_body(x);
		move_body(x);
	}*/

}

