///////////////////////////////////////////////////////
//
// FileName: First.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Program Description:
//    This program uses our PIC 16F84 to drive a DC Motor
//  using the reading from a Potentiometer off of the
//  Analog to Digital converter at ADCON1.
//    It does this by first sending out, using an LED array
//  the current digital value, and transmits this as a variable
//  power using the main method.
//
// Program History:
//    4/14/2001: Operational
//        Currently using the main program to run DC Motor
// Future Plans:
//    Set up the motor driver to use interrupts rather than
//  call the main program.
//
// Known Bugs:
//
////////////////////////////////////////////////////////

#include "16f877.h"
#include "sercomm.h"

//Timing settings
#pragma CLOCK_FREQ 20000000

char inval;
char led = 1;
char intr_count = 0;
char wait = 0;

void interrupt(void) {
	// assume it's a timer0 interrupt
	// work on multiplexing this function later.

	// if inval = 0, output will always be 0.
    if (intr_count < inval) {
        // PWM hi
        output_low_port_b( 0 );
    }
    else {
        // PWM lo
        output_high_port_b( 0 );
    }
	
    intr_count++;
	// this should roll over from 255 to 0.

    if( led ) {
        output_high_port_b( 1 );
        led = 0;
    }
    else {
        output_low_port_b( 1 );
        led = 1;
    }

    clear_wdt();
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
    OPTION_REG = 0x00; // set pre_scaler to 1:256
    TRISB = 0; // port B as outputs

	// init...
    inval = 0; intr_count = 0; led = 0;
	
	ser_init(SER_9600);
	
    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

	while (1) {
		ser_tx('!');
    }

}

