//This sample program for the PIC 16F84 target shows how
//to use interrupts. If there is a LED connected to
//B7 it will blink.

char led = 1;
char wait=0;

void interrupt( void )
{
    if (wait==0) {
        if( led )
        {
            output_high_port_b( 1 );
            led = 0;
        }
        else
        {
            output_low_port_b( 1 );
            led = 1;
        }
    }
    wait++;

    clear_bit( INTCON, T0IF );  //clear TMR0 overflow flag
}

main()
{
    set_bit( STATUS, RP0 );
    OPTION_REG = 7;  //set prescaler to 1:256
    set_tris_b( 0 );
    clear_bit( STATUS, RP0 );
    output_port_b( 0 );

    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit


    while( 1 ); //endless loop
}

/*
    EOF
*****************/ 
