///////////////////////////////////////////////////////
//
// FileName: five.c
// Author: kwanjee@andrew.cmu.edu
//
// Servo control with serial interface.
// upgraded to sercomm.h
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define DC_PORT PORTB
#define DC1_ENB 4
#define DC1_DIR 5
#define DC2_ENB 2
#define DC2_DIR 1

#define SERVO_PORT PORTD
#define SERVO_PIN  0

char servo_state = 0;
char servo_count = 0;
char servo_pos = 128; // init to middle
char led = 0;

void interrupt(void) {

    //clear_wdt();

	// this should roll over from 255 to 0.
    if( led<127 ) {
    	set_bit(BLINK_PORT, BLINK_PIN);
    }
    else {
        clear_bit(BLINK_PORT, BLINK_PIN);
    }
    led++;

	///////////////////////////////////////////////////////////
	// servo control, 1:32 prescaler on TMR0
    if (servo_state == 1) {
		// pre stage
		set_bit(SERVO_PORT,SERVO_PIN);
		servo_state = 2;
        TMR0 = 180; // == 256 - 105
	}
	else if (servo_state == 2) {
        // control hi stage
		servo_state = 3;
        TMR0 = servo_pos;
	}
    else if (servo_state == 3) {
        // control lo stage
        servo_state = 4;
        clear_bit(SERVO_PORT,SERVO_PIN);
        TMR0 = 255 - servo_pos;
    }
    else if (servo_state == 4) {
		// wait stage
        clear_bit(SERVO_PORT,SERVO_PIN);
		servo_count++;
		if (servo_count > 8) {
			// exit wait stage
			servo_state = 1;
            servo_count = 0;
		}
    }
	///////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////

	
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
    set_bit( STATUS, RP0 );
    OPTION_REG = 0x04; // set pre_scaler to 1:32
    TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    clear_bit( STATUS, RP0 );
    PORTB = 0;
    PORTD = 0;

	ser_init();

    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

	putstring("\rPIC 16F877 Servo control program\r");
	putstring("Enter servo position (0-255) at the prompt.\r");
	servo_state = 1;
	while (1) {
		ser_tx('>');
		servo_pos = getdec();
        putstring("servoing to position ");
        putdec(servo_pos);
		ser_tx('\r');
    }
}

