///////////////////////////////////////////////////////
//
// FileName: First.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Program Description:
//    This program uses our PIC 16F84 to drive a DC Motor
//  using the reading from a Potentiometer off of the
//  Analog to Digital converter at ADCON1.
//    It does this by first sending out, using an LED array
//  the current digital value, and transmits this as a variable
//  power using the main method.
//
// Program History:
//    4/14/2001: Operational
//        Currently using the main program to run DC Motor
// Future Plans:
//    Set up the motor driver to use interrupts rather than
//  call the main program.
//
// Known Bugs:
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"

char inval;
char led = 1;
char intr_count = 0;
char wait = 0;

void interrupt(void) {
	// assume it's a timer0 interrupt
	// work on multiplexing this function later.

	// if inval = 0, output will always be 0.
    if (intr_count < inval) {
        // PWM hi
        clear_bit(PORTB, 4);
    }
    else {
        // PWM lo
        set_bit(PORTB, 4 );
    }
	
    intr_count++;
	// this should roll over from 255 to 0.

    if( led ) {
        set_bit(PORTB, 0);
        led = 0;
    }
    else {
        clear_bit(PORTB, 0);
        led = 1;
    }

    clear_wdt();
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	set_bit( STATUS, RP0 );
    	OPTION_REG = 0x00; // set pre_scaler to 1:256
    	TRISB = 0; // port B as outputs
    	TRISD = 0; // prot D as outputs
	ADCON1 = 0x00; // port A all analog, result left justified
    
    	clear_bit( STATUS, RP0 );
    	PORTB = 0;
    	PORTD = 0;

	// init...
    	inval = 0; intr_count = 0; led = 0;
	
    	enable_interrupt( GIE );
    	enable_interrupt( T0IE );  //enable TMR0 overflow bit

	//Set Phase of Motors
	set_bit(PORTB, 5);
    set_bit(PORTB, 1);

    set_bit(PORTC, 5);
	
	ADCON0 = 0x81; // 0b 1000 0001 activate A/D, ch 0, Tad = Fosc/32

	while (1) {
	        delay_us(12); // wait for Tacq
     
		ADCON0 |= 4; // ADC go!
	
        	while (ADCON0 & 4); // wait for AD to complete

	        delay_us(4); // wait for 2Tad
        	inval = ADRESH; // capture value
	        PORTD = inval;

    }

}

