///////////////////////////////////////////////////////
//
// FileName: softenc.c
// Author: kwanjee@andrew.cmu.edu
//
// Software encoder counter, uses interrupt on change
// feature on pins RB4:5
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

char enc_hi, enc_lo, enc_state;
char rb_tmp, rb_prev;

void interrupt(void) {
	set_bit(PORTB,0);

	/*rb_prev = rb_tmp;
	rb_tmp = PORTB & 0x30;
	
	if (rb_tmp == 0x30) {
		if (rb_prev == 0x10) {
			// increment
			if (enc_lo == 255) enc_hi++;
			enc_lo++;
		}
		else {
			// decrement
			if (enc_lo == 0) enc_hi--;
			enc_lo--;
		}
	}
	else if (rb_tmp == 0x00) {
		if (rb_prev == 0x10) {
			// decrement
			if (enc_lo == 0) enc_hi--;
			enc_lo--;
		}
		else {
			// increment
			if (enc_lo == 255) enc_hi++;
			enc_lo++;
		}
	}*/

	rb_tmp = PORTB & 0x30;
	// trigger on ch A
	if (rb_tmp) {
		if (PORTD & 0x80) {
			if (enc_state == 1) {
				if (enc_lo == 0) enc_hi--;
				enc_lo--;
			}
			else enc_state = 1;
		}
		else {
			if (enc_state == 0) {
				if (enc_lo == 255) enc_hi++;
				enc_lo++;
			}
			else enc_state = 0;
		}
	}
	else {
		if (PORTD & 0x80) enc_state = 0;
		else enc_state = 1;
	}

	clear_bit(PORTB,0);

    clear_bit( INTCON, RBIF );  //interrupt handled.
}


void main(void) {
	char inp;
	char hi1, lo1;
	char hi2, lo2;
	char diff;

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0x30; // RB4:5 as inputs
	TRISD = 0x80; // port D as outputs

	PORTB = 0;
	PORTD = 0;

	// init...
	ser_init(); // init rs-232 comms

	enable_interrupt(GIE);
    enable_interrupt(RBIE);  //enable RBchange interrupt

	putstring("\rSoftware encoder counter test\r");
	
	while (1) {
		inp = ser_rx();
		if (inp == 'r') {
			// reset
			enc_hi = 0; enc_lo = 0;
			ser_tx('\r');
		}
		
		puthex(enc_hi); puthex(enc_lo);
		ser_tx('\r');
	}
}

