//RS232 example for the PIC target

#include "16f877.h"

//RS232 settings
#pragma RS232_TXPORT PORTC
#pragma RS232_RXPORT PORTC
#pragma RS232_TXPIN  6
#pragma RS232_RXPIN  7
#pragma RS232_BAUD 38400

//Timing settings
#pragma CLOCK_FREQ 20000000

char state = 0;
char flag = 0;

void printf( const char* text )
{
    char i = 0;
    while( text[i] != 0 )
        putchar( text[i++] ); 
}

void sendHEXNumber( char data )
{
    //Send high nibble
    if( (data>>4) > 9 )
        putchar( 'A' - 10 + (data>>4) );
    else
        putchar( '0' + (data>>4) );
    //Send low nibble
    if( (data&0x0F) > 9 )
        putchar( 'A' - 10 + (data&0x0F) );
    else
        putchar( '0' + (data&0x0F) );
}

void sendDECNumber( char data )
{
    putchar( '0' + data/100 );
    putchar( '0' + (data%100)/10 );
    putchar( '0' + data%10 );
}

main()
{
    //Hardware Initialization
    disable_interrupt( GIE );
    set_bit( STATUS, RP0 );
	TRISC = 128;
    set_tris_b( 0 );
    clear_bit( STATUS, RP0 );
    output_port_a( 0 );
    output_port_b( 0 );
    
    printf( "\n\r\n\r--- RS232 example for the PIC target ---\n\r\n\r" );
    printf( "Enter 'H' for hex numbers or any\n\r" );
    printf( "other key for decimal numbers:\n\r" );
    
    //input from user
    flag = getchar();
    //Go to the next line
    putchar( '\n' );
    putchar( '\r' );
    //set the correct flag
    if( flag == 'h' || flag == 'H' )
        flag = 0;
    
    while(1)
    {
        if( flag == 0 )
            sendHEXNumber( state++ );
        else
            sendDECNumber( state++ );
        if( state&0x0f )
            putchar( ' ' );
        else
        {
            //Go to the next line
            putchar( '\n' );
            putchar( '\r' );
        }
        
        delay_ms( 250 );
    }
}
