///////////////////////////////////////////////////////
//
// FileName: pid3.c
// Author: kwanjee@andrew.cmu.edu
//
// Closed loop control test
// with integers!
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define ENC_PORT PORTB
#define ENC_RST  2
#define ENC_OE   4
#define ENC_SEL  5

void enc_init(void) {
	set_bit(ENC_PORT,ENC_RST); // reset
	set_bit(ENC_PORT,ENC_SEL);
}

void enc_reset(void) {
	clear_bit(ENC_PORT,ENC_RST);
	set_bit(ENC_PORT,ENC_RST);
}

char enc_read_lo(void) {
	char lo;

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	clear_bit(ENC_PORT,ENC_OE); // OE
	lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable

	return lo;
}

////////////////////////////////////////////////////////////
// 16 bit encoder reading code...
/*		clear_bit(ENC_PORT,ENC_SEL); // sel hi
		clear_bit(ENC_PORT,ENC_OE); // OE
		hi1 = PORTD;		

		set_bit(ENC_PORT,ENC_SEL); // sel lo
		lo1 = PORTD;
		set_bit(ENC_PORT,ENC_OE); // output disable*/
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

void main(void) {
	char inp, vel, Pvel, Dvel;
	char prevvel;
	char lo1, lo2;

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	putstring("\rVelocity control test\r");
	
	vel = 0;
	putstring(" Vel>");
	inp = getdec();
		
	while (1) {
		// proportional control:
		// dV = Kp dv

		prevvel = vel;
		lo1 = enc_read_lo();
		delay_ms(3);
		lo2 = enc_read_lo();
		vel = lo2-lo1;

		Pvel = inp - vel; // proportional
		Dvel = vel - prevvel; // derivitive

		dc_vel[0] = dc_vel[0] + Pvel; // Kp == 1
		Dvel = Dvel << 2; // Kd == 4
		dc_vel[0] = dc_vel[0] - Dvel;

		pwm_setvel(0,dc_vel[0]);

		putdec(vel); ser_tx(' ');
		putdec(Dvel); ser_tx(' ');
		putdec(Pvel); ser_tx(' ');
		putdec(dc_vel[0]); ser_tx('\r');

	}
}

