///////////////////////////////////////////////////////
//
// FileName: pid.c
// Author: kwanjee@andrew.cmu.edu
//
// Closed loop control test
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define ENC_PORT PORTB
#define ENC_RST  2
#define ENC_OE   4
#define ENC_SEL  5

char enc_hi, enc_lo;
char ah, al;
char bh, bl;
char xh, xl;
char mulcount;
char mulstat;

void enc_init(void) {
	set_bit(ENC_PORT,ENC_RST); // reset
	set_bit(ENC_PORT,ENC_SEL);
}

void enc_reset(void) {
	clear_bit(ENC_PORT,ENC_RST);
	set_bit(ENC_PORT,ENC_RST);
}

char enc_read_8(void) {
	char lo;

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	clear_bit(ENC_PORT,ENC_OE); // OE
	lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable

	return lo;
}

void enc_read_16(void) {
	clear_bit(ENC_PORT,ENC_SEL); // sel hi
	clear_bit(ENC_PORT,ENC_OE); // OE
	enc_hi = PORTD;		

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	enc_lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable*/
}

// xh:xl = - ah:al
void neg16(void) {
	al = ~ al;
	ah = ~ ah;
	al++;
	if (STATUS & 1) ah++;
}

// calculates ah:al - bh:bl
void sub16(void) {
	xl = al - bl;
	if (~STATUS & 1) xh = 0xff;
	else xh = 0;
	xh = xh - ah - bh;
}

// calculates ah:al + bh:bl
void add16(void) {
	xl = al + bl;
	if (STATUS & 1) xh = 1;
	else xh = 0;
	xh = xh + ah + bh;
}

// al * bl = xh:xl, signed
void mult_8(void) {
asm {
	movf	_al,W
	movwf	_xl
	movf	_bl,W

	xorwf	_xl,F
	bcf		_mulstat,0
	btfsc	_xl,7
	bsf		_mulstat,0
	xorwf	_xl,F

	; make both operands positive
	btfss	_xl,7
	goto	alpositive
	comf	_xl,F
	incf	_xl,F
alpositive
	btfss	_bl,7
	goto	blpositive
	movwf	_xh
	comf	_xh,F
	incf	_xh,W
blpositive
	clrf	_xh
	movlw	8
	movwf	_mulcount

mul_loop
	btfsc	_xl,0
	addwf	_xh,F
	bcf		STATUS,C
	rrf		_xh,F
	rrf		_xl,F
	decfsz	_mulcount,F
	goto	mul_loop

	btfss	_mulstat,0		;if don't need to flip result
	return

	; negate result
	comf	_xl,F
	comf	_xh,F
	movlw	1
	addwf	_xl,F
	btfsc	STATUS,C
	addwf	_xh,F
	return
}
}

void main(void) {
	char vel; // desired velocity
	char v; // instantaneous velocity
	char dv; // proportional error in velocity
	char pdv; // previous proportional error
	char d2v; // change in proportional error
	char Y; // PID output
	char Kp; // P term constant
	char Kd; // D term constant

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	putstring("\rVelocity control test\r");
	
	vel = 0;
	dv = 0;
	Kp = 64;

	putstring(" Vel>");
	vel = getdec();
	
	while (1) {
		set_bit(PORTB,0);

		// 16 bit signed arithmetic!!!!!

		v = enc_read_8();
		enc_reset();

		pdv = dv;
		dv = vel - v;

		d2v = dv - pdv;

		//Y = Kp * dv;
		al = Kp; bl = dv; 
		mult_8();
		Y = xh;

		pwm_setvel_dir(0,Y);

		putdec(v); ser_tx(' ');
		putdec(dv); ser_tx(' ');
		putdec(d2v); ser_tx(' ');
		putdec(xh); ser_tx(' ');
		putdec(xl); ser_tx('\r');

		clear_bit(PORTB,0);

		while (TMR0 != 0);
	}
}

