/*
 *  
 * I2C slave mode routines
 *
 */
 
#ifndef _I2CM_H_
#ifndef _I2CS_H_
#define _I2CS_H_

#define I2C_SLAVE_READ 0
#define I2C_SLAVE_WRITE 1
#define I2C_MASTER_ACK 0
#define I2C_MASTER_NACK 1
#define I2C_DATA_READ 2
#define I2C_STOP 255

char i2c_tmp;
char i2c_data;

// initializes MSSP for I2C
void i2c_init(char addr) {
	
	// enable SSP, I2C slave mode, 7 bit addr
	SSPCON = 00110110b;
	SSPADD = addr << 1; // UNDOCUMENTED!!!!!
	
	// slew rate control enabled, i2c spec input levels
	SSPSTAT = 0;

	// I/O pins as inputs (RC3,4)
	TRISC |= 0x18;
}

// slave receive
char i2c_rx(void) {
	while (!(PIR1 & 8));
	clear_bit(PIR1,SSPIF);
		
	if (SSPSTAT & 4) { // check R/W bit
		// if he wants to read, we have to write
		// CKP cleared in hardware to stall for time
		return I2C_SLAVE_WRITE;
	}
	else {
		// master write, slave read
		
		// this is either our address or the incoming data
		// either way, must clear it to prevent SSPOV
		i2c_data = SSPBUF; 
		if (SSPSTAT & 0x20) {
			// just got the incoming data
			return I2C_DATA_READ;
		}
		else {
			// just got address with write command
			// exit, then get called again to rx incoming data
			
			return I2C_SLAVE_READ;
		}
	}
}

// transmit data
// returns 1 if master NACK, else returns 0
char i2c_tx(char data) {
	
	SSPBUF = data; // send data

	set_bit(SSPCON,CKP); // release clock line

	ser_tx('<');

	while (!(PIR1 & 8)); // wait for tx to finish
	clear_bit(PIR1, SSPIF); // clear interrupt
	
	ser_tx('>');
	
	// if R/W == 0, master says NACK
	if (SSPSTAT & 4) {
		return I2C_MASTER_ACK;
	}
	else {
		return I2C_MASTER_NACK;
	}
}

#endif
#endif
