///////////////////////////////////////////////////////
//
// FileName: i2ctest.c
// Author: kwanjee@andrew.cmu.edu
//
// I2C testing program
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "i2cbb.h"

void main(void) {
	char nack;
	char inp, num, i;
	char state = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	i2c_init(35); // i2c slave, addr 35

	clear_bit(TRISB,0);
	clear_bit(PORTB,0);

	putstring("\rI2C bitbang slave\r");
	
	num = 0x82;
	
	while (1) {
		//puthex(SSPSTAT);
		//puthex(SSPCON);
		if (state == 0) {
			inp = i2c_rx();
			switch (inp) {
				case I2C_SLAVE_READ: ser_tx('('); break;
				case I2C_DATA_READ: ser_tx(i2c_data); break;
				case I2C_SLAVE_WRITE: //ser_tx(':'); 
										state = 1; break;
			}
		}
		else {
			num++;
			inp = i2c_tx(num);
			puthex(inp);
			if (inp == I2C_MASTER_NACK) state = 0;
		}
	}
}

