///////////////////////////////////////////////////////
//
// FileName: hctl.c
// Author: kwanjee@andrew.cmu.edu
//
// HP quadrature decoder test
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define ENC_PORT PORTB
#define ENC_RST  2
#define ENC_OE   4
#define ENC_SEL  5

void interrupt(void) {
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void enc_reset() {
	clear_bit(ENC_PORT,ENC_RST);
	set_bit(ENC_PORT,ENC_RST);
}

char enc_read_lo(void) {
	char lo;

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	clear_bit(ENC_PORT,ENC_OE); // OE
	lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable

	return lo;
}

////////////////////////////////////////////////////////////
// 16 bit encoder reading code...
/*		clear_bit(ENC_PORT,ENC_SEL); // sel hi
		clear_bit(ENC_PORT,ENC_OE); // OE
		hi1 = PORTD;		

		set_bit(ENC_PORT,ENC_SEL); // sel lo
		lo1 = PORTD;
		set_bit(ENC_PORT,ENC_OE); // output disable*/
////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////

void main(void) {
	char inp;
	char hi1, lo1;
	char hi2, lo2;
	char diff;

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
//	TRISC = TRISC & 11001111b; // port C 4,5 as output
    
    PORTB = 0;
//    PORTD = 0;

	// init...
	ser_init(); // init rs-232 comms
	init_pwm(); // initialize CCP module

    enable_interrupt(GIE);
    enable_interrupt(T0IE);  //enable TMR0 overflow bit

	putstring("\rHP encoder counter test\r");
	
	hi1 = 0xde; lo1 = 0xad;

	set_bit(ENC_PORT,ENC_RST); // reset
	set_bit(ENC_PORT,ENC_SEL);
	while (1) {
		inp = ser_rx();
		if (inp == 'r') {
			// reset
		}
		
		lo1 = enc_read_lo();
		delay_ms(3);
		lo2 = enc_read_lo();
		
		diff = lo2-lo1;	putdec(diff); ser_tx('\r');

	}
}

