/*
 *  Quadrature counting using Timer1 and US Digital interface chip
 */

#ifndef _ENCUSDIG_H_
#define _ENCUSDIG_H_

char enc_h, enc_l;
char enc_prev_h, enc_prev_l;
char enc_tmp;

void enc_init(void) {
	
	// activate timer 1,
	// 1:1 prescale, osc off, use external clk, don't synchronize
	T1CON = 0x07;	
	
	set_bit(TRISB,1); // dir input
	set_bit(TRISC,0); // count input
	
    enable_interrupt(RBIE);  //enable RBchange interrupt		
}

char enc_read(void) {
	
	enc_tmp = ~enc_h;
	while (enc_tmp != enc_h) {
		enc_h = TMR1H;
		enc_l = TMR1L;
		enc_tmp = TMR1H;
	}
	
	if (PORTB & 0x02) {
		enc_h = ~enc_h;
		enc_l = ~enc_l;
		enc_l++;
		if (enc_l == 0) enc_h++;
	}
	
	enc_l = enc_l + enc_prev_l;
	// check carry...
	if (STATUS & 1) enc_h++;
	enc_h = enc_h + enc_prev_h;
	
	return enc_l;
}

void enc_reset(void) {
	T1CON &= 0xFE; // timer1 OFF
	enc_prev_h = 0;
	enc_prev_l = 0;
	TMR1L = 0;
	TMR1H = 0;
	T1CON |= 0x01; // timer1 ON
}

#endif