// serial interface routines header

#pragma RS232_TXPORT PORTC
#pragma RS232_RXPORT PORTC
#pragma RS232_TXPIN  6
#pragma RS232_RXPIN  7

char serial_h_tmp;

void putstring(const char* text) {
    char i = 0;
    while( text[i] != 0 )
        putchar( text[i++] ); 
}

void puthex(char data) {
	serial_h_tmp = data >> 4;
    //Send high nibble
    if (serial_h_tmp > 9)
        putchar( 'A' - 10 + serial_h_tmp );
    else
        putchar( '0' + serial_h_tmp );
	serial_h_tmp     = data & 0x0F;
    //Send low nibble
    if( serial_h_tmp > 9 )
        putchar( 'A' - 10 + serial_h_tmp );
    else
        putchar( '0' + serial_h_tmp );
}

void putdec(char data) {
    putchar( '0' + data/100 );
    putchar( '0' + (data%100)/10 );
    putchar( '0' + data%10 );
}

char getdec(void) {
	char i=0;

    serial_h_tmp = 0;
    while ((serial_h_tmp != '\n')&&(serial_h_tmp != '\r')) {
		serial_h_tmp = getchar();
	
		if ((serial_h_tmp > 47)&&(serial_h_tmp < 58)) {
			// it's a digit!
			i = i * 10;
            serial_h_tmp = serial_h_tmp - 48;
            i = i + serial_h_tmp;
		}
    }
	
	return i;
}
