//
// Hobby servo routines
// Controls 8 hobby servos from 1 I/O port
//

#ifndef _SERVO_H_
#define _SERVO_H_

#define SERVO_PORT PORTB
#define SERVO_TRIS TRISB

// servo control variables
char servo_state = 0;
char servo_count = 0;
char servo_curr = 0;
char servo_mask = 0;
char servo_switch = 1;
char servo_pos[8] = {0,0,0,0,0,0,0,0};

/* required interrupt service routine, hooked to Timer0

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

    clear_bit( INTCON, T0IF );  //interrupt handled.

*/

void servo_init(void) {
	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)
    SERVO_TRIS = 0; // port D as outputs	
    enable_interrupt(T0IE);  //enable TMR0 overflow bit
}

#endif