///////////////////////////////////////////////////////
//
// FileName: sertest.c
// Author: kwanjee@andrew.cmu.edu
//
// Commandline control program, inputs and outputs
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

//RS232 settings
#pragma RS232_TXPORT PORTB
#pragma RS232_RXPORT PORTB
#pragma RS232_TXPIN  0
#pragma RS232_RXPIN  1
#pragma RS232_BAUD 9600

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	2

char blink = 0;

void interrupt(void) {

	if (blink) {
		set_bit(PORTB, 2);
		blink = 0;
	}
	else {
		clear_bit(PORTB, 2);
		blink = 1;
	}

	clear_bit(INTCON, T0IF);
}

void main(void) {
	char inp, num;

	OPTION_REG = 0x04;
	
	TRISB = 2;
    PORTB = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms

	enable_interrupt(T0IE);
	enable_interrupt(GIE);

	putstring("\rSerial Echo\r");
	
//	inp = getchar();
//	puthex(inp);
	
	while (1) {
		//inp = ser_rx();
		//putchar(inp);
		inp = getchar();
		puthex(inp);
		ser_tx(' ');
		//ser_tx(inp);
	}
}

