///////////////////////////////////////////////////////
//
// FileName: i2ctest.c
// Author: kwanjee@andrew.cmu.edu
//
// I2C testing program
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "i2cm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

void main(void) {
	char nack;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	i2c_init();

	clear_bit(TRISC,5);
	clear_bit(PORTC,5);

	putstring("\rI2C test\r");
	
	while (1) {
		ser_rx();
		putstring("open ");
		nack = i2c_open(0x0F,0);
		
//		if (nack) ser_tx('!');
//		else ser_tx('.');
		
//		puthex(SSPSTAT);
//		puthex(SSPCON);
//		puthex(SSPCON2);
		
//		ser_tx('=');
		
//		clear_bit(SSPCON2,ACKSTAT);
		nack = i2c_tx(0xAA);

		if (nack) ser_tx('!');
		else ser_tx('.');
		
		puthex(SSPSTAT);
		puthex(SSPCON);
		puthex(SSPCON2);
		
		i2c_close();
		
		ser_tx('\r');
	}
}

