/*
 *  
 * I2C slave mode routines
 *
 */
 
#ifndef _I2CM_H_
#ifndef _I2CS_H_
#define _I2CS_H_

#define I2C_SLAVE_READ 0
#define I2C_SLAVE_WRITE 1
#define I2C_MASTER_ACK 0
#define I2C_MASTER_NACK 1

char i2c_tmp;
char i2c_data;

// initializes MSSP for I2C
void i2c_init(char addr) {
	
	// enable SSP, I2C slave mode, 7 bit addr
	SSPCON = 00110110b;
	SSPADD = addr;
	//clear_bit(SSPADD,7); // ensure
	
	// slew rate control enabled, i2c spec input levels
	SSPSTAT = 0;

	// I/O pins as inputs (RC3,4)
	TRISC |= 0x18;
}

// wait for address match
// returns what the slave should do next
char i2c_listen(void) {
	
	if (!(SSPSTAT & 8)) {
		// no start bit yet...
		while (!(SSPSTAT & 8)) { // wait for start bit
			// if he sends stop, take care of it anyway.
			if ((SSPSTAT & 0x10) && (PIR1 & 0x08)) {
				clear_bit(PIR1, SSPIF);
				ser_tx('~');
			}
		}
		while (!(PIR1 & 8)); // wait for SSPIF
		clear_bit(PIR1, SSPIF); // clear interrupt
	
		i2c_tmp = SSPBUF;
	}
	
	// have address already, data byte next...
	if (SSPSTAT & 0x04) return I2C_SLAVE_WRITE;
	else return I2C_SLAVE_READ;
}

// reads received byte
char i2c_rx(void) {
	while (!(PIR1 & 8)) { // wait for byte to come in
		// if he sends stop, jump out with error
		if (SSPSTAT & 0x10) {
			clear_bit(PIR1,SSPIF);
			return 0;
		}
	}
	clear_bit(PIR1, SSPIF); // clear interrupt

	return SSPBUF;
}

// transmit data
// returns 1 if master NACK, else returns 0
char i2c_tx(char data) {
	
	SSPBUF = data; // send data

	clear_bit(SSPCON,CKP); // release clock line

	while (!(PIR1 & 4)); // wait for tx to finish
	clear_bit(PIR1, SSPIF); // clear interrupt
	
	// if R/W == 0, master says NACK
	if (SSPSTAT & 4) {
		return I2C_MASTER_NACK;
	}
	else {
		return I2C_MASTER_ACK;
	}
}

#endif
#endif
