/*
 *  Quadrature counting using up down counters
 *  Timer0 for Up count, Timer1 for Down count
 */

#ifndef _ENCUPDN_H_
#define _ENCUPDN_H_

char TMR0H;
char enc_h, enc_l;
// snapshot counter values
char up_h, up_l, dn_h, dn_l;
char enc_tmp;

/*
required ISR on Timer0 overflow
this gives us 16bit resolution in Timer0

	if (INTCON & 0x20) {
		TMR0H++;
		clear_bit(INTCON,T0IF);
	}

*/

void enc_init(void) {
	
	// activate timer 1,
	// 1:1 prescale, osc off, use external clk, don't synchronize
	T1CON = 0x07;	
	set_bit(TRISC,0); // up input
	
	// activate timer 0,
	// transition on external input, inc on posedge, 1:1 prescale
	OPTION_REG &= 0xE0;
	OPTION_REG |= 0x20;
	
    enable_interrupt(T0IE);  //enable tmr0 overflow interrupt
}

char enc_read(void) {	
	// encoder reading = upcount - downcount
	enc_tmp = ~dn_h;
	while (enc_tmp != dn_h) {
		dn_h = TMR1H;
		dn_l = TMR1L;
		enc_tmp = TMR1H;
	}	

	up_h = TMR0H; up_l = TMR0;
	
	// 16bit subtraction
	enc_l = up_l - dn_l;
	if (~STATUS & 1) up_h--;
	enc_h = up_h - dn_h;

	return enc_l;
}

void enc_reset(void) {
	T1CON &= 0xFE; // timer1 OFF
	TMR1L = 0;
	TMR1H = 0;
	TMR0 = 0;
	TMR0H = 0;
	T1CON |= 0x01; // timer1 ON
}

#endif