//
// Routines to read HCTL-2016 encoder conounters
//

#ifndef _ENCODER_H_
#define _ENCODER_H_

#define ENC_PORT PORTB
#define ENC_RST  2
#define ENC_OE   4
#define ENC_SEL  5

char enc_hi, enc_lo;

void enc_init(void) {
	set_bit(ENC_PORT,ENC_RST); // reset
	set_bit(ENC_PORT,ENC_SEL);
}

void enc_reset(void) {
	clear_bit(ENC_PORT,ENC_RST);
	set_bit(ENC_PORT,ENC_RST);
}

char enc_read_8(void) {
	char lo;

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	clear_bit(ENC_PORT,ENC_OE); // OE
	lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable

	return lo;
}

void enc_read_16(void) {
	clear_bit(ENC_PORT,ENC_SEL); // sel hi
	clear_bit(ENC_PORT,ENC_OE); // OE
	enc_hi = PORTD;		

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	enc_lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable*/
}

#endif