///////////////////////////////////////////////////////
//
// FileName: findelmo.c
// Author: kwanjee@andrew.cmu.edu
//
// ElmoFinder (tm)
// proportional steering
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "servo.h"

#define SERVOX 0
#define SERVOY 1

#define CENTERX 9
#define CENTERY 71

char xpos, ypos;
char dx, dy;

void interrupt(void) {

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

    clear_bit( INTCON, T0IF );  //interrupt handled.
    
    return;
}

void move_camera(char x, char y) {
	char pxpos, pypos;
	
	dx = CENTERX - x;
	pxpos = xpos;
	xpos = xpos + dx;
	xpos = xpos + dx; 
	if (x < CENTERX) {
		//if (xpos < 250) xpos = xpos + 5;
		// dx is positive, it should increase
		if (xpos < pxpos) xpos = 255; // saturate
	}
	else if (x > CENTERX) {
		//xpos = xpos - 5 ;
		// dx is negative, it should decrease
		if (xpos > pxpos) xpos = 1; // saturate
	}

	dy = CENTERY - y;
	pypos = ypos;
	// arithmetic shift right dy
	dy = dy >> 1;
	if (dy & 0x40) set_bit(dy,7);
	ypos = ypos + dy;
	
	if (y < CENTERY) {
		//if (ypos < 250) ypos = ypos + 5;
		// dy is positive, it should increase
		if (ypos < pypos) ypos = 255; // saturate
	}
	else if (y > CENTERY) {
		//if (ypos > 5) ypos = ypos - 5;
		// dy is negative, it should decrease 
		if (ypos > pypos) ypos = 1; // saturate
	}

	servo_pos[SERVOX] = xpos;
	servo_pos[SERVOY] = ypos;

	return;
}

void main(void) {
	char inp, num, grab_state;
	
	// elmo coords
	char ex,ey,ez;

	// init...
	ser_init(); // init rs-232 comms
	servo_init();
	
	TRISB = 0; // port B as outputs
    PORTB = 0;

	TRISC = TRISC & 0xF0; // port C bits 0 to 3 as output
	clear_bit(PORTC,0);
	clear_bit(PORTC,1);
	clear_bit(PORTC,2);

    enable_interrupt(GIE);

	servo_state = 1; // activate servo driver

	servo_pos[SERVOX] = 128;
	servo_pos[SERVOY] = 128;
	xpos = 128;
	ypos = 128;

	grab_state = 0;
	inp = 0;
	ex = 0; ey = 0; ez = 0;

	while (1) {
		
		//PORTC = grab_state & 0x07;
/*		if (grab_state == 0) set_bit(PORTC,0);
		else clear_bit(PORTC,0);
		if (grab_state == 1) set_bit(PORTC,1);
		else clear_bit(PORTC,1);
		if (grab_state == 2) set_bit(PORTC,2);
		else clear_bit(PORTC,2);
		if (grab_state == 3) set_bit(PORTC,3);
		else clear_bit(PORTC,3);*/
		
		// read next input
		inp = 0;
		
		set_bit(PORTC,0);
		while (inp != 241) {
			inp = ser_rx();
			ser_tx(inp);
		}
		clear_bit(PORTC,0);
		
		ex = ser_rx();
		ser_tx(ex);
		ey = ser_rx();
		ser_tx(ey);
		ez = ser_rx();
		ser_tx(ez);
		
		ser_tx(xpos);
		ser_tx(ypos);
		
		if ((ex | ey | ez) != 0) {
			move_camera(ex,ey);
			putdec(dx); ser_tx(' ');
			putdec(dy); ser_tx(' ');
			putdec(xpos); ser_tx(' ');
			putdec(ypos); ser_tx('\r');
		}
		
/*
		switch (grab_state) {
		case 0: // wait for start byte
				if (inp == 241) grab_state = 1;
				else grab_state = 0;
				break;
		case 1: // elmo x
				if (inp < 20) {
					ex = inp;
					grab_state = 2;
				}
				else grab_state = 0;
				break;
		case 2: // elmo y
				if (inp < 144) {
					ey = inp;
					grab_state = 3;
				}
				else grab_state = 0;
				break;
		case 3: // elmo z
				if (inp < 240) {
					ez = inp;
					// got everything, time to move...
					if ((ex | ey | ez) != 0) {
						// elmo seen
						move_camera(ex,ey);
					}
				}
				grab_state = 0;
				break;
		default: grab_state = 0; break;
	}*/
	
	}
	
	
	return;
}

