///////////////////////////////////////////////////////
//
// Filename: pwm20k.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Software PWM test
// slower hardware pwm rate
// can also... faster == better?
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

char inval;
char intr_count = 0;

void interrupt(void) {

	if (PIR1 & 0x02) {
		// timer2 overflow
		
		if (intr_count) {
			set_bit(PORTB,0);
		}
		else {
			clear_bit(PORTB,0);
		}
	
		intr_count = ~intr_count;

    	clear_bit(PIR1,TMR2IF);  //interrupt handled.
    }
}

void main(void) {
	set_bit( STATUS, RP0 );
   	OPTION_REG = 0x00; // set pre_scaler to 1:1
   	TRISB = 0; // port B as outputs
   	TRISD = 0; // prot D as outputs
    
   	clear_bit( STATUS, RP0 );
   	PORTB = 0;
   	PORTD = 0;

	// init...
   	inval = 0; intr_count = 0;
	//ser_init();
	pwm_init();

   	//enable_interrupt(TMR2IF);  //enable TMR0 overflow bit
   	set_bit(PIE1,TMR2IE);
   	enable_interrupt(PEIE);
   	enable_interrupt(GIE);

	//Set Phase of Motors
	//set_bit(PORTB, 5);
    //set_bit(PORTB, 1);

//	putstring("Hardware PWM test\r");
//	putstring("Vel? ");
//	inval = getdec();
//	pwm_setvel(0,inval);
	while (1) {
		//puthex(TMR2); ser_tx('\r');
		delay_ms(10);
		set_bit(PORTB,1);
		delay_ms(10);
		clear_bit(PORTB,1);
	}
}

