///////////////////////////////////////////////////////
//
// FileName: pprk.c
// Author: kwanjee@andrew.cmu.edu
//
// DumbWanderer on the PPRK
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "adc.h"

#define FWD 240
#define REV 10

#define THRESH 100

#define SERVO_PORT PORTD
char servo_state = 0;
char servo_count = 0;
char servo_curr = 0;
char servo_mask = 0;
char servo_switch = 1;
char servo_pos[8] = {0,0,0,0,0,0,0,0};

void interrupt(void) {

	set_bit(PORTB,0);

	//////////////////////////////////////////////////////////////////////
	// servo controller routine
	//////////////////////////////////////////////////////////////////////
	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}
	//////////////////////////////////////////////////////////////////////
	//////////////////////////////////////////////////////////////////////

	clear_bit(PORTB,0);

	clear_bit( INTCON, T0IF );  //interrupt handled.
}

char find_min(char a, char b, char c) {
	if (a<b) {
		if (a<c) return 0;
		else return 2;
	}
	else if (b<c) {
		return 1;
	}
	else return 2;
}

void main(void) {
	char dist0, dist1, dist2;
	char dir;

	set_bit( STATUS, RP0 );
	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0
	TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    clear_bit( STATUS, RP0 );
    PORTB = 0;
    PORTD = 0;

    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

	ser_init();
	//adc_init(0); // init to all ports analog, result left justified
	ADCON1 = 0x00;

	putstring("\rPPRK Wanderer\r");
	servo_state = 1;
	
	while (1) {
		dir = 3; // assume stuck

		dist0 = adc_read(0);
		dist1 = adc_read(1);
		dist2 = adc_read(2);

		// find a dir to move in...
		if (dist0<THRESH) {
			ser_tx('!');
			servo_pos[0] = 0;
			servo_pos[1] = FWD;
			servo_pos[2] = REV;
			dir = 0; // not stuck anymore
			while (dist0 < THRESH) {
				dist0 = adc_read(0);
			}
		}
		if (dist1<THRESH) {
			servo_pos[1] = 0;
			servo_pos[2] = FWD;
			servo_pos[0] = REV;
			dir = 1; // not stuck anymore
			while (dist1 < THRESH) {
				dist1 = adc_read(1);
			}
		}
		if (dist2<THRESH) {
			servo_pos[2] = 0;
			servo_pos[0] = FWD;
			servo_pos[1] = REV;
			dir = 2; // not stuck anymore
			while (dist2 < THRESH) {
				dist2 = adc_read(2);
			}
		}

		if (dir == 3) {
			// stuck, rotate on the spot
			servo_pos[0] = FWD;
			servo_pos[1] = FWD;
			servo_pos[2] = FWD;
		}
	}
}

