///////////////////////////////////////////////////////
//
// FileName: i2ctest.c
// Author: kwanjee@andrew.cmu.edu
//
// I2C testing program
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "i2cm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

void main(void) {
	char nack;
	char inp, num, i;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	i2c_init();

	clear_bit(TRISC,5);
	clear_bit(PORTC,5);

	putstring("\rI2C master\r");
	
	while (1) {
		num = ser_rx();
		num = num - 48;
		if (i2c_open(35,I2C_READ)) {
			ser_tx('!');
		}
		else {
			for (i=0; i<num; i++) {
				inp = i2c_rx();
				i2c_nack(0);
				puthex(inp);
			}
			inp = i2c_rx();
			i2c_nack(1);
			puthex(inp);
			
			i2c_close();
		}
		
		
/*		ser_tx('>');
		inp = ser_rx();
		if (inp == '1') {
			if (i2c_open(35,I2C_WRITE)) {
				ser_tx('!');
			}
			else {
				ser_tx('.');
			}
		}
		else if (inp == '0') {
			i2c_close();
			ser_tx('\r');
		}
		else {
			if (i2c_tx(inp)) {
				ser_tx('!');
			}
			else {
				ser_tx('.');
			}
		}*/
	}
}

