///////////////////////////////////////////////////////
//
// FileName: enccnt.c
// Author: kwanjee@andrew.cmu.edu
//
// encoder counting using UpDnDir chip
// Timer1 for counting, portB pin for dir
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "encusdig.h"

void interrupt(void) {

	if (INTCON & 0x01) {
		// PORTB change, direction change...
		
		enc_tmp = ~enc_h;
		while (enc_tmp != enc_h) {
			enc_h = TMR1H;
			enc_l = TMR1L;
			enc_tmp = TMR1H;
		}
		
		if (!(PORTB & 0x20)) {
			enc_h = ~enc_h;
			enc_l = ~enc_l;
			enc_l++;
			if (enc_l == 0) enc_h++;
		}
		
		enc_prev_l = enc_l + enc_prev_l;
		// check carry...
		if (STATUS & 1) enc_h++;
		enc_prev_h = enc_h + enc_prev_h;
	
		TMR1L = 0;
		TMR1H = 0;
		
		clear_bit(INTCON, RBIF);  //interrupt handled.
	}

}

void main(void) {
	char inp, v;

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0x00; 
	TRISD = 0x80; // port D as outputs

	PORTB = 0;
	PORTD = 0;

	// init...
	ser_init(); // init rs-232 comms
	enc_init(); // init encoder counter
	
	enable_interrupt(GIE);

	putstring("\rCounter test\r");

	while (1) {
		inp = ser_rx();
		if (inp == 'r') {
			// reset
			enc_reset();
			ser_tx('\r');
		}
		
//		set_bit(PORTB,0);
//		enc_read();
//		clear_bit(PORTB,0);     
		
//		puthex(enc_h); puthex(enc_l); ser_tx(' ');
//		puthex(enc_prev_h); puthex(enc_prev_l); ser_tx(' ');

		v = enc_read();
		puthex(enc_h); puthex(enc_l); ser_tx(' ');		
		puthex(v);
		
		ser_tx('\r');
	}
}
