///////////////////////////////////////////////////////
//
// FileName: ten.c
// Author: kwanjee@andrew.cmu.edu
//
// Commandline control program, inputs and outputs
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "adc.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define DC_PORT PORTB
#define DC1_ENB 4
#define DC1_DIR 5
#define DC2_ENB 2
#define DC2_DIR 1

#define SERVO_PORT PORTD

// hardware pwm control variables
char ccpcon;
char dc_vel[2] = {0,0};

// servo control variables
char servo_state = 0;
char servo_count = 0;
char servo_curr = 0;
char servo_mask = 0;
char servo_switch = 1;
char servo_pos[8] = {0,0,0,0,0,0,0,0};


void interrupt(void) {

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void init_pwm(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0x3f; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	CCPR2L = 255;
	TRISC = TRISC & 11111001b; // set CCP pins to output
	
	ccpcon = 00001100b; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	set_bit(T2CON,TMR2ON);
}

void pwm_setvel(char n, char c) {
	char tmp;

	tmp = (~c) & 0x03;
	tmp = tmp << 4;

	if (n == 0) {
		CCP1CON = tmp | ccpcon;
		CCPR1L = (~c) >> 2;
	}
	else if (n==1) {
		CCP2CON = tmp | ccpcon;
		CCPR2L = (~c) >> 2;
	}
}

void main(void) {
	char inp, num;

	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    PORTB = 0;
    PORTD = 0;

	// init...
	ser_init(); // init rs-232 comms
	ADCON1 = 0; // all channels analog, output MSBs
	init_pwm(); // initialize CCP module
	servo_state = 1; // activate servo driver

    enable_interrupt(GIE);
    enable_interrupt(T0IE);  //enable TMR0 overflow bit

	putstring("\rCommand Line Interface\r");
	
	while (1) {
		putstring("Cmd?");
		inp = ser_rx();
		putstring(" Num?");
		num = ser_rx() - 48;

		if (inp == 'd') {
			if (num<2) {
				putstring(" Vel: ");
				dc_vel[num] = getdec();
				pwm_setvel(num,dc_vel[num]);
			}
		}
		else if (inp == 's') {
			if (num<9) {
				putstring(" Pos: ");
				servo_pos[num] = getdec();
			}
		}
		else if (inp == 'a') {
			if (num < 9) {
				inp = adc_read(num);
				putstring(" ADC: ");
				putdec(inp);
				ser_tx('\r');
			}
		}
	}
}

