// PIC 16F877 Hardware PWM routines using the CCP module
//
// Runs at 19.5 kHz by default

#ifndef _PWM_H_
#define _PWM_H_

#define DC_PORT PORTC
#define DC1_DIR 3
#define DC2_DIR 0

// hardware pwm control variables
char ccpcon;
char dc_vel[2] = {0,0};

void pwm_init(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0xff; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	CCPR2L = 255;
	TRISC = TRISC & 11110000b; // set DC motor pins to output
	
	ccpcon = 00111100b; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	set_bit(T2CON,TMR2ON);
}

void pwm_setvel(char n, char c) {
	if (n == 0) {
		CCPR1L = (~c);
	}
	else if (n==1) {
		CCPR2L = (~c);
	}
}

void pwm_setveldir(char n, char ch, char cl, char d) {
	if (n == 0) {
		if (d == 0) set_bit(DC_PORT,DC1_DIR);
		else clear_bit(DC_PORT,DC1_DIR);
		cl = cl >> 2;
		CCP1CON = (~cl) & ccpcon;
		CCPR1L = (~ch);
	}
	else if (n==1) {
		if (d == 0) set_bit(DC_PORT,DC2_DIR);
		else clear_bit(DC_PORT,DC2_DIR);
		cl = cl >> 2;
		CCP2CON = (~cl) & ccpcon;
		CCPR2L = (~ch);
	}
}

/*
void init_pwm(void) {
	
	// init hardware PWM
	CCP1CON = 0; // CCP off
	CCP2CON = 0;
	TMR2 = 0;
	PR2 = 0x3f; // 0x3f: 78kHz, 0xff: 19.5kHz
	CCPR1L = 255; // output is inverted, so this means stop
	CCPR2L = 255;
	TRISC = TRISC & 11111001b; // set CCP pins to output
	
	ccpcon = 00001100b; // setup reg mask
	
	CCP1CON = ccpcon; // CCP module to PWM mode
	CCP2CON = ccpcon;

	set_bit(T2CON,TMR2ON);
}

void pwm_setvel(char n, char c) {
	char tmp;

	tmp = (~c) & 0x03;
	tmp = tmp << 4;

	if (n == 0) {
		CCP1CON = tmp | ccpcon;
		CCPR1L = (~c) >> 2;
	}
	else if (n==1) {
		CCP2CON = tmp | ccpcon;
		CCPR2L = (~c) >> 2;
	}
}
*/

#endif