///////////////////////////////////////////////////////
//
// FileName: pid.c
// Author: kwanjee@andrew.cmu.edu
//
// Simple control
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "pwm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

#define ENC_PORT PORTB
#define ENC_RST  2
#define ENC_OE   4
#define ENC_SEL  5

char enc_hi, enc_lo;
char ah, al;
char bh, bl;
char xh, xl;
char mulcount;
char mulstat;

void enc_init(void) {
	set_bit(ENC_PORT,ENC_RST); // reset
	set_bit(ENC_PORT,ENC_SEL);
}

void enc_reset(void) {
	clear_bit(ENC_PORT,ENC_RST);
	set_bit(ENC_PORT,ENC_RST);
}

char enc_read_8(void) {
	char lo;

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	clear_bit(ENC_PORT,ENC_OE); // OE
	lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable

	return lo;
}

void enc_read_16(void) {
	clear_bit(ENC_PORT,ENC_SEL); // sel hi
	clear_bit(ENC_PORT,ENC_OE); // OE
	enc_hi = PORTD;		

	set_bit(ENC_PORT,ENC_SEL); // sel lo
	enc_lo = PORTD;
	set_bit(ENC_PORT,ENC_OE); // output disable*/
}

// xh:xl = - ah:al
void neg16(void) {
	al = ~ al;
	ah = ~ ah;
	al++;
	if (STATUS & 1) ah++;
}

// calculates ah:al - bh:bl
void sub16(void) {
	xl = al - bl;
	if (~STATUS & 1) xh = 0xff;
	else xh = 0;
	xh = xh - ah - bh;
}

// calculates ah:al + bh:bl
void add16(void) {
	xl = al + bl;
	if (STATUS & 1) xh = 1;
	else xh = 0;
	xh = xh + ah + bh;
}

// al * bl = xh:xl, signed
void mult_8(void) {

	xh = al ^ bl;
	if (xh & 0x80) mulstat = 1;
	else mulstat = 0;

	if (al > 127) al = 0-al;
	if (bl > 127) bl = 0-bl;

asm {
	movlw	8
	movwf	_mulcount
	movf	_al,W
	movwf	_xl
	movf	_bl,W
	clrf	_xh
mul_loop
	bcf		STATUS,C
	btfsc	_xl,0
	addwf	_xh,F
	rrf		_xh,F
	rrf		_xl,F
	decfsz	_mulcount,F
	goto	mul_loop
}
	
	if (mulstat == 1) {
		xl = ~xl;
		xh = ~xh;
		xl = xl + 1;
		if (STATUS & 1) {
			xh = xh + 1;
		}
	}

	return;
}

void main(void) {
	char vel; // desired velocity
	char v; // instantaneous velocity
	char dv; // proportional error in velocity
	char pdv; // previous proportional error
	char d2v; // change in proportional error
	char sdvh, sdvl; // sum of proportional error
	char Yh, Yl; // PID output
	char modY, sigY;
	char Kp; // P term constant
	char Kd; // D term constant
	char Ki; // I term constant

	OPTION_REG = 0x05; // TMR0 @ 1:64, prescaler to timer0 (pid loop freq)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	putstring("\rVelocity control test\r");
	
	vel = 0;
	dv = 0;
	sdvh = 0;
	sdvl = 0;
	Kp = 2;
	Kd = 2;
	Ki = 1;

	xh = 0;

	putstring(" Vel>");
	vel = getdec();
	
	while (1) {
		set_bit(PORTB,0);

		// 16 bit signed arithmetic!!!!!

		v = enc_read_8();
		enc_reset();

		if (v < vel) xh++;
		else if (v > vel) xh--;

		// figure out sign & magnitude
		if (xh & 0x80) {
			sigY = 1;
			modY = ~xh;
			modY++;		// modY now positive magnitude
			modY = modY << 1;
		}
		else {
			sigY = 0;
			modY = xh << 1;
		}

		pwm_setvel_dir(0,modY,sigY);

		putdec(v); ser_tx(' ');
//		putdec(dv); ser_tx(' ');
//		putdec(d2v); ser_tx(' ');
//		putdec(sdvh); ser_tx(' ');
		puthex(xh); ser_tx(' ');
//		puthex(xl); ser_tx(' ');
		puthex(sigY); ser_tx(' ');
		puthex(modY); ser_tx('\r');

		clear_bit(PORTB,0);

		while (TMR0 != 0);
	}
}

