///////////////////////////////////////////////////////
//
// FileName: six.c
// Author: kwanjee@andrew.cmu.edu
//
// Multiple servo control
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

#define SERVO_PORT PORTD

char servo_state = 0;
char servo_count = 0;
char servo_curr = 0;
char servo_mask = 0;
char servo_switch = 1;
char servo_pos[8] = {128,128,128,128,128,128,128,128};

void interrupt(void) {

	set_bit(PORTB,0);

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

	clear_bit(PORTB,0);

	clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	char inp;
	char mot;

	set_bit( STATUS, RP0 );
	OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0
	TRISB = 0; // port B as outputs
    TRISD = 0; // port D as outputs
    
    clear_bit( STATUS, RP0 );
    PORTB = 0;
    PORTD = 0;

    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

	ser_init();

	putstring("\nPIC 16F877 Servo control program\n");
	servo_state = 1;
	while (1) {

		putstring("M?");
		mot = ser_rx() - 48;
		ser_tx('\r');
		putstring("M");
		putdec(mot);
		putstring(" V?");
		inp = getdec();

		servo_pos[mot] = inp;

	}
}

