///////////////////////////////////////////////////////
//
// FileName: servocon.c
// Author: kwanjee@andrew.cmu.edu
//
// Serial servo controller
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"
#include "servo.h"

void interrupt(void) {

	if (servo_state == 1) {
		// next intr in 0.6 ms
		TMR0 = 180;

		if (servo_pos[servo_curr] != 0)
			SERVO_PORT = SERVO_PORT | servo_switch; // output hi
		
		servo_switch = servo_switch << 1;
		if (servo_switch == 0) servo_switch = 1;
		
		servo_state = servo_state + 1;
		servo_count = 0;
	}
	else if (servo_state == 2) {
		TMR0 = 255 - servo_pos[servo_curr];
		servo_state = 3;
	}
	else if (servo_state == 3) {
		SERVO_PORT = 0; // output lo
		TMR0 = servo_pos[servo_curr];
		servo_curr = servo_curr + 1;
		servo_curr = servo_curr & 0x07;
		servo_state = 1;
	}

    clear_bit( INTCON, T0IF );  //interrupt handled.
}

void main(void) {
	char inp, num;

	//OPTION_REG = 0x04; // TMR0 @ 1:32, prescaler to timer0 (for servo control)

	// init...
	ser_init(); // init rs-232 comms
	servo_init();
	
	TRISB = 0; // port B as outputs
    PORTB = 0;

    enable_interrupt(GIE);

	servo_state = 1; // activate servo driver

	//putstring("\rCommand Line Interface\r");
	
	while (1) {
		putstring(">");
		num = ser_rx() - 48;
		servo_pos[num] = getdec();
	}
}

