///////////////////////////////////////////////////////
//
// FileName: sertest.c
// Author: kwanjee@andrew.cmu.edu
//
// Commandline control program, inputs and outputs
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"
#include "sercomm.h"

#define BLINK_PORT 	PORTB
#define BLINK_PIN  	0

char blink = 0;

void interrupt(void) {

	if (blink) {
		set_bit(PORTB, 0);
		blink = 0;
	}
	else {
		clear_bit(PORTB, 0);
		blink = 1;
	}

	clear_bit(INTCON, T0IF);
}

void main(void) {
	char inp, num;

	OPTION_REG = 0x04;
	
	TRISB = 0; // port B as outputs
    PORTB = 0;

	// init...
	ser_init(); // init rs-232 comms

	enable_interrupt(T0IE);
	enable_interrupt(GIE);

	putstring("\rSerial Echo\r");
	
	while (1) {
		inp = ser_rx();
		ser_tx(inp);		
	}
}

