// serial interface routines header

#ifndef _SERCOMM_H_
#define _SERCOMM_H_

// SPBRG_VAL based on BRGH=0
// SPBRG_VAL == ( Fosc / 64*baudrate ) - 1
// 2400:  192
// 9600:  31
// 19200: 15

// SPBRG_VAL for BRGH=1
// SPBRG_VAL == ( Fosc / 16*baudrate ) - 1
// 9600: 129
// 19.2: 64
// 38.4: 31
// 57.6: 21
// 115.2: 10
#define SPBRG_VAL 129

#include "16f877.h"

char ser_tmp;

void ser_init(void) {
	
	SSPCON = 0;
	PIR1 = 0;

	clear_bit(PIR1,RCIF);
	clear_bit(PIE1,RCIE);
	clear_bit(PIR1,TXIF);	
	clear_bit(PIE1,TXIE);

	TRISC = TRISC | 0xC0; // setup TRISC for USART use

	SPBRG = SPBRG_VAL;

    //TXSTA = 00100000b; // txen, the rest all off
    TXSTA = 00100100b; // txen, brgh
	// check that TXIF == 1

	RCSTA = 10010000b; // spen and cren, the rest all off

	ser_tmp = RCREG; // flush the rx buffer
	ser_tmp = RCREG;
	ser_tmp = RCREG;

	//TXREG = 0; // tx dummy char

}

void ser_tx(char c) {

	//wait for txif to go hi
	set_bit(PORTB,1);
	while (!(PIR1 & 16));
	clear_bit(PORTB,1);
	
	//disable_interrupt(GIE); //?
	TXREG = c;
	//enable_interrupt(GIE);  //?
}

char ser_rx(void) {
	while (1) {
		if (RCSTA & 2) {
			// overflow error
			// disable_interrupt(GIE)?
			clear_bit(RCSTA,CREN); // disable reception
			ser_tmp = RCREG; // flush the rx buffer
			ser_tmp = RCREG;
			ser_tmp = RCREG;
			set_bit(RCSTA,CREN); // reenable reception
			// enable_interrupt(GIE)?
			//set_bit(PORTD,0);
		}
		else if (RCSTA & 4) {
			// framing error
			// disable_interrupt(GIE)?
			ser_tmp = RCREG;
			// enable_interrupt(GIE)?
			//set_bit(PORTD,1);
		}
		else if (PIR1 & 32) {
			// RCIF!
			// disable_interrupt(GIE)?
			ser_tmp = RCREG;
			// enable_interrupt(GIE)?
			
			return ser_tmp;
		}
	}
}

void putstring(const char* text) {
    char i = 0;
    while( text[i] != 0 )
        ser_tx( text[i++] ); 
}

void puthex(char data) {
	ser_tmp = data >> 4;
    //Send high nibble
    if (ser_tmp > 9)
        ser_tx( 'A' - 10 + ser_tmp );
    else
        ser_tx( '0' + ser_tmp );
	ser_tmp     = data & 0x0F;
    //Send low nibble
    if( ser_tmp > 9 )
        ser_tx( 'A' - 10 + ser_tmp );
    else
        ser_tx( '0' + ser_tmp );
}

void putdec(char data) {
    ser_tx( '0' + data/100 );
    ser_tx( '0' + (data%100)/10 );
    ser_tx( '0' + data%10 );
}

char getdec(void) {
	char i=0;
	
	ser_tmp = 0;
	
	while ((ser_tmp != '\n')&&(ser_tmp != '\r')) {
		ser_tmp = ser_rx();
	
		if ((ser_tmp > 47)&&(ser_tmp < 58)) {
			// it's a digit!
			i = i * 10;
			ser_tmp = ser_tmp - '0';
			i = i + ser_tmp;
		}
	} 
	
	return i;
}

#endif