/*
 *  Software serial port
 */

#ifndef _SERSOFT_H_
#define _SERSOFT_H_

// interleaved interrupt callback
#include "servo.h"
#include "sercom2.h"

// drive on yellow, float on blue
//#use rs232(baud=38400, bits=8, parity=N, xmit=PIN_B4, rcv=PIN_B5)

#define TO_ADDR 0 // eeprom address of timeout value
#define BR_ADDR 1 // eeprom address of baud rate

char rx_char;
char rx_done;
char bit_count;
#bit rx_bit = PORTB.5
#bit t1l_msb = TMR1L.7

char _timeout;
#bit timeout = _timeout.0
char to_val = 100;
char to_count;

void sersoft_init(void) {
	// init timeout timer (tmr1)
	
	char eeprom_val;
	
	eeprom_val = read_eeprom(BR_ADDR);
	/*if ((eeprom_val == 0x20)||(eeprom_val==0x10)) {
		T1CON = eeprom_val;
	}
	else T1CON = 0x00; // setup timer 1*/
	T1CON = 0x00;
	
	TMR1ON = 1;
	_timeout = 0;
	rx_done = 0;

	TRISB &= 0x0f; // RB4..7 all outputs
	TSB5 = 1; // only RB5 as input
	
	//while (!RB5);
	RBIF = 0;
	
	RBIE = 1;
	//TMR1IE = 1;
	PEIE = 1;
}

#INT_TIMER1
void timeout_isr(void) {
	// timer 1 overflow

	to_count++;
	if ((to_val != 0)&&(to_count > to_val)) 
		timeout = 1; // signal timeout
	TMR1IF = 0;
}

void to_reset(void) {
	// restart waiting for timeout
	TMR1ON = 0; // stop timer
	TMR1H = 0; // reset everything
	TMR1L = 0;
	to_count = 0;
	timeout = 0;
	TMR1ON = 1; // start timer
	
	TMR1IE = 1;
}

#INT_RB
void rx_isr(void) {
	// pre: only rx pin can trigger this interrupt
	// uses timer1 at 1:1
	// 128 ticks == 1 bit @ 38400
	
	// start bit!
	TMR1ON = 0;
	TMR1L = 0;
	TMR1H = 0;
	TMR1ON = 1;
	rx_done = 0;
	bit_count = 8;
	while ((bit_count--) > 0) {
		rx_char >>= 1;
		if (T0IF) do_servo();
		// wait for next bit
		while (!t1l_msb);
		TMR1L = 0;
		// shift in from left
		if (rx_bit) {
			rx_char |= 0x80;
		}
	}
	if (T0IF) do_servo();
	// wait for stop bit
	while (!rx_bit);

	rx_done = 1;

	// reset timer
	TMR1ON = 0;
	TMR1L = 0;
	TMR1H = 0;
	TMR1ON = 1;
	RBIF = 0;
}

char sw_getc(void) {
	RBIE = 1;
	while (!rx_done);
	rx_done = 0;
	return rx_char;
}

void sw_putc(char c) {
	#bit lsb = c.0
	char i;
	
	T0IE = 0; // disable servo updating during tx
	RBIE = 0; // disable receiver
	//RCIE = 0;

	TMR1H = 0;
	TMR1L = 0;
	TMR1ON = 1;
	RB4 = 0; // start bit
	i=8;
	while ((i--) > 0) {
		if (T0IF) do_servo();
		while (!t1l_msb) {
			//if (RCIF) do_hw_rx();
		}
		TMR1L = 0;
		RB4 = lsb;
		c = c >> 1;
	}
	if (T0IF) do_servo();
	while (!t1l_msb) {
		//if (RCIF) do_hw_rx();
	}
	TMR1L = 0;
	RB4 = 1; // stop bit
	if (T0IF) do_servo();
	while (!t1l_msb) {
		//if (RCIF) do_hw_rx();
	}
	
	T0IE = 1; // reenable servos
	RBIE = 1; // reenable receiver
	//RCIE = 1;
}

void sw_puthex(char data) {
	ser_tmp = data >> 4;
    //Send high nibble
    if (ser_tmp > 9)
        sw_putc( 'A' - 10 + ser_tmp );
    else
        sw_putc( '0' + ser_tmp );
	ser_tmp = data & 0x0F;
    //Send low nibble
    if( ser_tmp > 9 )
        sw_putc( 'A' - 10 + ser_tmp );
    else
        sw_putc( '0' + ser_tmp );
}

void sw_putdec(char data) {
    sw_putc( '0' + data/100 );
    sw_putc( '0' + (data%100)/10 );
    sw_putc( '0' + data%10 );
    
/*    char i;
    
    if (data < 200) {
    	data -= 200;
    	ser_tx('2');
    }
    if (data < 100) {
    	data -= 100;
    	ser_tx('1');
    }
    for (i='0'; data > 9; i++) {
    	data -= 10;
    	i++;
    }
    if (i > '0') ser_tx(i);
    ser_tx(data + '0');*/
}

char sw_getdec(void) {
	char i=0;
	
	ser_tmp = 0;
	
	while ((ser_tmp != '\n')&&(ser_tmp != '\r')) {
		ser_tmp = sw_getc();
	
		if ((ser_tmp > 47)&&(ser_tmp < 58)) {
			// it's a digit!
			i = i * 10;
			ser_tmp = ser_tmp - '0';
			i = i + ser_tmp;
		}
	} 
	
	return i;
}

#endif