// serial interface routines header

#ifndef _SERCOMM_H_
#define _SERCOMM_H_

#include "877reg.h"

// SPBRG_VAL based on BRGH=0
// SPBRG_VAL == ( Fosc / 64*baudrate ) - 1
// 2400:  192
// 9600:  31
// 19200: 15

// SPBRG_VAL for BRGH=1
// SPBRG_VAL == ( Fosc / 16*baudrate ) - 1
#define SER_9600 129
#define SER_19200 64
#define SER_38400 31
#define SER_57600 21
#define SER_115200 10

#define ser_gotchar (rx_sp != rx_ep)

char ser_tmp;

#define RX_BUF_SIZE 20
char rx_buf[RX_BUF_SIZE];
char rx_sp, rx_ep;

void ser_init(char spbrg_val) {
	
	SSPCON = 0;
	PIR1 = 0;

	RCIF = 0;
	TXIF = 0;
	RCIE = 0;
	TXIE = 0;

	TRISC = TRISC | 0xC0; // setup TRISC for USART use

	SPBRG = spbrg_val;

    //TXSTA = 00100000b; // txen, the rest all off
    TXSTA = 0b00100100; // txen, brgh
	// check that TXIF == 1

	RCSTA = 0b10010000; // spen and cren, the rest all off

	ser_tmp = RCREG; // flush the rx buffer
	ser_tmp = RCREG;
	ser_tmp = RCREG;

	//TXREG = 0; // tx dummy char

	for (ser_tmp=0; ser_tmp<RX_BUF_SIZE; ser_tmp++) rx_buf[ser_tmp] = '#';

	rx_sp = rx_ep = 0;
	RCIE = 1;

}

void hw_putc(char c) {

	//wait for txif to go hi
	while (!TXIF);
	GIE = 0;
	TXREG = c;
	GIE = 1;
}

char hw_getc(void) {
	while (1) {
		if (rx_sp != rx_ep) {
			// disable_interrupt(GIE)?
			RCIE = 0;
			ser_tmp = rx_buf[rx_sp];
			rx_sp++;
			if (rx_sp == RX_BUF_SIZE) rx_sp = 0;
			RCIE = 1;
			// enable_interrupt(GIE)?
			
			return ser_tmp;
		}
	}
}

void do_hw_rx(void) {
	// stuff incoming character into circular queue
	if (OERR) {
		// overflow error
		// disable_interrupt(GIE)?
		CREN = 0;
		/*ser_tmp = RCREG; // flush the rx buffer
		ser_tmp = RCREG;
		ser_tmp = RCREG;*/
		CREN = 1;
		// enable_interrupt(GIE)?
	}
	else if (FERR) {
		// framing error
		// disable_interrupt(GIE)?
		ser_tmp = RCREG;
		// enable_interrupt(GIE)?
		//set_bit(PORTD,1);
	}
	else {
		rx_buf[rx_ep++] = RCREG;
		//rx_ep++;
		if (rx_ep == RX_BUF_SIZE) rx_ep = 0;
	}
	RCIF = 0;

	return;
}

#INT_RDA
void ser_rx_isr(void) {

	do_hw_rx();
	
	return;
}

void hw_puthex(char data) {
	ser_tmp = data >> 4;
    //Send high nibble
    if (ser_tmp > 9)
        hw_putc( 'A' - 10 + ser_tmp );
    else
        hw_putc( '0' + ser_tmp );
	ser_tmp = data & 0x0F;
    //Send low nibble
    if( ser_tmp > 9 )
        hw_putc( 'A' - 10 + ser_tmp );
    else
        hw_putc( '0' + ser_tmp );
}

void hw_putdec(char data) {
    hw_putc( '0' + data/100 );
    hw_putc( '0' + (data%100)/10 );
    hw_putc( '0' + data%10 );
}

char hw_getdec(void) {
	char i=0;
	
	ser_tmp = 0;
	
	while ((ser_tmp != '\n')&&(ser_tmp != '\r')) {
		ser_tmp = hw_getc();
	
		if ((ser_tmp > 47)&&(ser_tmp < 58)) {
			// it's a digit!
			i = i * 10;
			ser_tmp = ser_tmp - '0';
			i = i + ser_tmp;
		}
	} 
	
	return i;
}

#endif