///////////////////////////////////////////////////////
//
// FileName: rover.c
// Author: kwanjee@andrew.cmu.edu
//
// Personal Rover platform test
// servo steering test
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercom2.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"
#include "db.h"

#define center0 133
#define center1 124

signed char i_pos[19] = {0, 7, 15, 23, 33, 42, 53, 64, 75, 86, 97, 107, 116, -119, -111, -104, -98, -92, -86};

signed char o_pos[19] = {0, 6, 12, 18, 23, 28, 33, 37, 41, 46, 50, 54, 58, 62, 67, 71, 76, 81, 86};

// velocities are factors of v_f_o, shifted left by 6 bits

// 5 deg steps, index 18 is turning angle of 90 degrees
signed char v_b_o[19] = {64, 64, 63, 62, 61, 60, 58, 57, 55, 53, 51, 49, 47, 44, 42, 39, 36, 32, 29};

signed char v_b_i[19] = {64, 58, 53, 48, 42, 37, 32, 27, 23, 18, 13, 8, 3, -2, -7, -12, -17, -23, -29};

signed char v_f_i[19] = {64, 59, 54, 50, 46, 44, 42, 40, 40, 40, 40, 42, 44, 46, 49, 52, 56, 60, 64};


void checkret(char db, char ret, char x) {
	if (ret != 0) {
		sw_putc("error db");
		sw_putdec(db); sw_putc(' ');
		sw_putdec(ret); sw_putc(" at ");
		sw_putdec(x); sw_putc('\r');
	}
}

void main(void) {
	signed char db, vin, vprev;
	signed char pos_in, dir;
	signed char flvel, frvel, blvel, brvel, tmp;

	char ret;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	GIE = 1;

	sw_putc("rover remote\r");

	/*db = 0;
	while ((ret = db_off(db)) != 0) {
		checkret(db, ret, 0);
	}
	while ((ret = db_set_vel(db,0)) != 0) {
		checkret(db, ret, 1);
	}
	while ((ret = db_controller_on(db)) != 0) {
		checkret(db, ret, 2);
	}*/
	
	/*
	for (db=0; db<3; db++) {
		while ((ret = db_off(db)) != 0) {
			checkret(db, ret, 0);
		}
		while ((ret = db_set_vel(db,0)) != 0) {
			checkret(db, ret, 1);
		}
		while ((ret = db_controller_on(db)) != 0) {
			checkret(db, ret, 2);
		}
	}
	*/

/*	ret = 1;
		while (ret != 0) {
		ret = db_off(3);
		sw_putc('+');
		checkret(3, ret, 0);
	}

	ret = db_set_vel(3,0);
	checkret(3, ret, 1);			
	ret = db_controller_on(3);
	checkret(3, ret, 2);*/

	// vin (7) range from 101 to 153, midpoint at 128
	// pos_in (4) range from 103 to 153, midpoint at 128
	// mode_in (5) range from 110 to 146, midpoint at 

	sw_putc("go\r");

	servo_state = 1; // activate servo driver

	servo_pos[0] = 133;
	servo_pos[1] = 124;

	while (1) {
		pos_in = adc_read(4);
		pos_in -= 128;
		// we have 13 external angles and 6 internal angles
		if (pos_in > 26) pos_in = 26;
		if (pos_in < -26) pos_in = -26;
		
		vin = adc_read(7);
		vin = 128 - vin;
		vin = vin << 2;

		if (pos_in < 0) {
			// turn left
			pos_in = -pos_in;
			pos_in >>= 1;
			servo_pos[0] = center0 + i_pos[pos_in];
			servo_pos[1] = center1 + o_pos[pos_in];
			dir = 0;
		}
		else {
			// turn right
			pos_in >>= 1;
			servo_pos[0] = center0 - o_pos[pos_in];
			servo_pos[1] = center1 - i_pos[pos_in];
			dir = 1;
		}
	}
	
/*	while (1) {
		sw_putc("vin?"); vin = sw_getdec();
		sw_putc("pos_in?"); pos_in = sw_getdec();
		sw_putc("v_f_i = "); sw_putdec(v_f_i[pos_in]); sw_putc('\r');
		flvel = ((signed long)vin * (signed long)v_f_i[pos_in]) >> 6;
		sw_putc("flvel = "); sw_putdec(flvel); sw_putc('\r');
	}*/
}

