///////////////////////////////////////////////////////
//
// FileName: rover.c
// Author: kwanjee@andrew.cmu.edu
//
// Personal Rover platform test
// dc speed control, 4 daughterboards
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercom2.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"
#include "db.h"

void checkret(char db, char ret, char x) {
	if (ret != 0) {
		sw_putc("error db");
		sw_putdec(db); sw_putc(' ');
		sw_putdec(ret); sw_putc(" at ");
		sw_putdec(x); sw_putc('\r');
	}
}

void main(void) {
	signed char db, vin, vprev;
	char ret;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	servo_state = 1; // activate servo driver

	GIE = 1;

	sw_putc("rover remote\r");

	/*db = 0;
	while ((ret = db_off(db)) != 0) {
		checkret(db, ret, 0);
	}
	while ((ret = db_set_vel(db,0)) != 0) {
		checkret(db, ret, 1);
	}
	while ((ret = db_controller_on(db)) != 0) {
		checkret(db, ret, 2);
	}*/
	for (db=0; db<3; db++) {
		while ((ret = db_off(db)) != 0) {
			checkret(db, ret, 0);
		}
		while ((ret = db_set_vel(db,0)) != 0) {
			checkret(db, ret, 1);
		}
		while ((ret = db_controller_on(db)) != 0) {
			checkret(db, ret, 2);
		}
	}
/*	ret = 1;
		while (ret != 0) {
		ret = db_off(3);
		sw_putc('+');
		checkret(3, ret, 0);
	}

	ret = db_set_vel(3,0);
	checkret(3, ret, 1);			
	ret = db_controller_on(3);
	checkret(3, ret, 2);*/

	servo_pos[0] = 133;
	servo_pos[1] = 124;

	// vin range from 101 to 153, midpoint at 128

	sw_putc("go\r");
	while (1) {
		//delay_ms(10);
		vin = adc_read(7);
		vin = 128 - vin;
		vin = vin << 2;
		if (vin != vprev) {
			for (db=0; db<3; db++) {
				ret = db_set_vel(db,vin);
				checkret(db, ret, 3);
			}
			//db = 0;
			//ret = db_set_vel(db,vin);
			//checkret(db, ret, 3);
			vprev = vin;
			sw_putdec(vin);
			sw_putc('\r');
		}
	}
}

