#ifndef _ROVER_H_
#define _ROVER_H_

#include "i2cm.h"
#include "db2.h"
#include "adc.h"

#define SERVO_LEFT	0
#define SERVO_RIGHT	1

#define SERVO_PAN	2
#define SERVO_TILT	3

#define center0 133
#define center1 124

signed char rover_vel;
signed char rover_dir;
char rover_mode;

signed char const i_pos[19] = {0, 7, 15, 23, 33, 42, 53, 64, 75, 86, 97, 107, 116, -119, -111, -104, -98, -92, -86};

signed char const o_pos[19] = {0, 6, 12, 18, 23, 28, 33, 37, 41, 46, 50, 54, 58, 62, 67, 71, 76, 81, 86};

// velocities are factors of v_f_o, shifted left by 6 bits

// 5 deg steps, index 18 is turning angle of 90 degrees
signed char const v_b_o[19] = {64, 64, 63, 62, 61, 60, 58, 57, 55, 53, 51, 49, 47, 44, 42, 39, 36, 32, 29};

signed char const v_b_i[19] = {64, 58, 53, 48, 42, 37, 32, 27, 23, 18, 13, 8, 3, -2, -7, -12, -17, -23, -29};

signed char const v_f_i[19] = {64, 59, 54, 50, 46, 44, 42, 40, 40, 40, 40, 42, 44, -46, -49, -52, -56, -60, -64};

char db_init(char db) {
	char i, fail;
	
	fail = 1;
	
	fail = db_off(db);
	fail += db_set_vel(db,0);
	fail += db_controller_on(db);
	
	return fail;
}

char rover_init(void) {
	char fail;
	
	fail = db_init(0);
	fail += db_init(1);
	fail += db_init(2);
	fail += db_init(3);
	
	return fail;
}

// -18 < pos_in < 18
// -128 < vin < 127
char rover_move(signed char pos_in, signed char vin) {
	char i, fail;
	signed char dir, pivot;
	signed char flvel, frvel, blvel, brvel, tmp;

	// we have 13 external angles and 6 internal angles
	if (pos_in < 0) {
		pos_in = -pos_in;
		dir = 0;
	}
	else {
		dir = 1;
	}

	// saturate turning angle
	if (pos_in > 18) pos_in = 18;

	//// stabilize pivoting direction
	//if (pos_in == 18) dir = 0;

	// now, pos_in is offset into lut
	// figure out wheel velocities
	// assume we are turning left
	frvel = vin;
	tmp = v_f_i[pos_in];
	flvel = ((signed long)vin * (signed long)tmp) >> 6;
	tmp = v_b_i[pos_in];
	blvel = ((signed long)vin * (signed long)tmp) >> 6;
	tmp = v_b_o[pos_in];
	brvel = ((signed long)vin * (signed long)tmp) >> 6;

/*	sw_putc("vel = ");
	sw_putdec(flvel); sw_putc(' ');
	sw_putdec(frvel); sw_putc(' ');
	sw_putdec(brvel); sw_putc(' ');
	sw_putdec(blvel); sw_putc('\r');

	sw_putc("v_f_i="); sw_putdec(v_f_i[pos_in]);
	sw_putc(" v_b_i="); sw_putdec(v_b_i[pos_in]);
	sw_putc(" v_b_o="); sw_putdec(v_b_o[pos_in]);
	sw_putc('\r');*/

	if (dir == 0) {
		// turn left
		if (vin != 0) {
			servo_pos[SERVO_LEFT] = center0 + i_pos[pos_in];
			servo_pos[SERVO_RIGHT] = center1 + o_pos[pos_in];
		}
	}
	else {
		// oops, we are turning right
		// swap left and right
		tmp = frvel;
		frvel = flvel;
		flvel = tmp;
		
		tmp = brvel;
		brvel = blvel;
		blvel = tmp;

		// turn right
		if (vin != 0) {
			servo_pos[SERVO_LEFT] = center0 - o_pos[pos_in];
			servo_pos[SERVO_RIGHT] = center1 - i_pos[pos_in];
		}
	}

	fail  = db_set_vel(0,flvel);
	//sw_putdec(fail); sw_putc(' ');
	fail += db_set_vel(1,frvel);
	//sw_putdec(fail); sw_putc(' ');
	fail += db_set_vel(2,blvel);
	//sw_putdec(fail); sw_putc(' ');
	fail += db_set_vel(3,brvel);
	//sw_putdec(fail); sw_putc('\r');

	return fail;

}

void boom_move(char pos) {
	
	// boom position limiting
	if (pos > 215) {
		pos = 215;
	}
	if (pos < 85) {
		pos = 85;
	}
	
	if (adc_read(0) > pos) {
		pwm_setvel10(0,1,0xff,0xc0);
		pwm_setvel10(1,1,0xff,0xc0);
		while (adc_read(0) > pos);
	}
	else {
		pwm_setvel10(0,0,0xff,0xc0);
		pwm_setvel10(1,0,0xff,0xc0);
		while (adc_read(0) < pos);
	}
		
	pwm_setvel10(0,0,0,0);
	pwm_setvel10(1,0,0,0);
	
	return;	
}

#endif