///////////////////////////////////////////////////////
//
// FileName: exp4.c
// Author: kwanjee@andrew.cmu.edu
//
// Back EMF PID control
//
////////////////////////////////////////////////////////

#include "16f877.h"

#include "877reg.h"
#include "adc.h"
#include "sercom2.h"
#include "dbpwm.h"
//#include "encupdn.h"
//#include "i2cs.h"

//#use delay(clock = 20000000)

#define putstring(x) hw_putc(x)

#define I2C_PREFIX 0xf8

//#define BLINK_PORT 	PORTB
//#define BLINK_PIN  	PORTB.0

signed Kp = 0;
signed Ki = 8;
signed Kd = 0;

void calc_pid();

signed vel; // desired velocity
signed adc_in;
signed curr_vel; // instantaneous velocity
signed e; // error in velocity
signed pe; // previous error
signed de; // change in error over time
signed ie; // sum of error over time
signed pie; // previous sum of error
signed long Y; // PID output

// Timer2 overflows at 20kHz
// PID @ 300Hz == once every 65 overflows 
// PID @ 100Hz == once every 65 overflows 
char pid_period = 195;
char t2_count = 0;
char pid_update = 0;

char modYl, modYh;
char sigY;

signed long modY;

signed long disp;

char _dir_swap;
#bit dir_swap = _dir_swap.0

char i2c_addr;
char tx_buf[10];
char txlen;
char bufcnt;
char bufptr;

char dump[50];
char dp = 0;
char dumpit;

char sat_add(char a, char b, char sub) {
	char res;
	
	if (sub) b = ~b + 1;

	res = a + b;

	if (!((a ^ b) & 0x80)) {
		if ((res ^ a) & 0x80) {
			if (res & 0x80) res = 0x7f;
			else res = 0x81;
		}
	}
	return res;
}

#INT_TIMER2
void tmr2intr(void) {

	// timer2 overflow
		
	// is it time to update PID?
	if (t2_count < pid_period) t2_count++;
	
	else {
		t2_count = 0;
		
		pwm_setvel(0,0,0);
		RB2 = 0;
		// wait for stabilize
		delay_us(200);

		RB2 = 1;
	    
	    ADCON0 |= 4; // acquire go!
	    while (ADCON0 & 4); // wait for AD to complete
    	delay_us(4); // wait for 2Tad
    	adc_in = ADRESH;
    	
		RB2 = 0;

		pwm_setvel(sigY,modYh,modYl);
		RB2 = 1;

		// cumulate displacement
		//disp = disp + (signed long)curr_vel;
		
		pid_update = 1;		
		
		curr_vel = adc_in - 0x7b;
		calc_pid();
	}	

	TMR2IF = 0; //interrupt handled.
}

void calc_pid() {
	char v;

	// update PID...
	// 16 bit signed arithmetic!!!!!

	// make local copy to prevent concurrency issues
	v = curr_vel;

	if (dumpit) {
		dump[dp++] = v;
		if (dp == 50) dp = 0;
	}

	// must saturate dv and d2v as well, 
	// else cannot handle large changes in vel

	pe = e;
	// e = vel - v;
	e = sat_add(vel,v,1);

	pie = ie;
	// ie = pie + e
	ie = sat_add(pie,e,0);

	//de = e - pe;
	de = sat_add(e,pe,1);

	Y = (signed long)Kp * e;

	Y = Y + (signed long)Ki * ie;

	Y = Y + (signed long)Kd * de;
		
	// saturate xh:xl to 10 bits magnitude
	// xh: chop off top 6 bits
	// if xh < 128, x is positive (sigY = 0)
	// else x is negative (sigY = 1, flip xl:xh)
	// at this point: xl:xh = magnitude. saturate it if necessary
	// if xh > 3, overflow, saturate
	// now, shift 2 bits right, setvel.

	if (Y > 1023) Y = 1023;
	if (Y < -1023) Y = -1023;
	if (Y > 0) {
		sigY = 0;
		modY = Y;
	}
	else {
		sigY = 1;
		modY = -Y;
	}
	
	modYh = modY >> 2;
	modYl = modY & 0xff;
	modYl = modYl << 6;
	
	// swap?
	if (dir_swap) {
		sigY = (~sigY) & 0x01;
	}

	pwm_setvel(sigY,modYh,modYl);
	
}

void main(void) {
	char inp;
	char i;

	TSB3 = 0;
	TSB2 = 0;
	TSB4 = 0;
	TSB5 = 0;

	OPTION_REG = 0x05; // TMR0 @ 1:64, prescaler to timer0 (pid loop freq)

	// init...
	ser_init(SER_115200); // init rs-232 comms
	pwm_init(); // init CCP module
	adc_init(0);

	ADCON0 = 0; // shift ch to correct bit position
	ADCON0 |= 0x81; // Tad = Fosc/32, ADC on.

	vel = 0; // init to 0
	e = 0;
	de = 0;
	ie = 0;
	disp = 0;

	dir_swap = 0; // powerup default to no swap

	TMR2IE = 0; // controller off
	PEIE = 1;
	GIE = 1;

	RB4 = 1; // brakes off
	RB5 = 0; // mode = 0

	RB2 = 0;
	hw_putc("exp4\r");
	hw_putc("Kp?");
	Kp = hw_getdec();
	hw_putc("Ki?");
	Ki = hw_getdec();
	hw_putc("Kd?");
	Kd = hw_getdec();
	RB2 = 1;

	hw_putc("enable tmr2\r");
	TMR2IE = 1;
	
	hw_putc("vel?");
	vel = hw_getdec();

	while (1) {
		if (pid_update) {
			hw_putc("adc="); hw_puthex(adc_in);
			hw_putc(" curr_vel="); hw_puthex(curr_vel);
			hw_putc(" e="); hw_puthex(e);
			hw_putc(" ie="); hw_puthex(ie);
			hw_putc(" Y="); hw_puthex(sigY); 
			hw_putc(' '); hw_puthex(modYh); hw_puthex(modYl);
			hw_putc('\r');
			pid_update = 0;
		}
	}
}


