///////////////////////////////////////////////////////
//
// FileName: exp1.c
// Author: kwanjee@andrew.cmu.edu
//
// Experiment 2
// Gear motors give better resolution response
// Without gearing, motor gives very high back emf 
// immediately after switch-off, leading to resolution
// problems.
//
////////////////////////////////////////////////////////


#include <16f877.h>
#include "877reg.h"
#include "sercom2.h"
//#include "sersoft.h"
//#include "servo.h"
#include "adc.h"
#include "pwm.h"
//#include "i2cm.h"

void main(void) {
	char inp, num;

	TSB3 = 0;
	TSB2 = 0; // RB2 as output
	RB2 = 0;
	TSB1 = 0;
	RB1 = 0;

	// init...
	//sersoft_init(); // init software serial port
	ser_init(SER_115200);
	//servo_init();
	pwm_init(); // initialize CCP module
	adc_init(0); // all channels analog, output MSBs

	PEIE = 1;
	GIE = 1;

	while (1) {
		RB2 = 1;
		hw_putc("speed: ");
		inp = hw_getdec();
	
		pwm_setvel8(0,0,inp);
		hw_putc("running...");
		inp = hw_getc();
		
		RB2 = 0;
		pwm_setvel8(0,0,0);
		hw_putc("stopped\r");
		inp = hw_getc();
	}
}

