///////////////////////////////////////////////////////
//
// FileName: sui.c
// Author: kwanjee@andrew.cmu.edu
//
// Serial user interface (implementing v0.2)
//
////////////////////////////////////////////////////////

//#opt 9

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

char buf[50];

void main(void) {
	char inp, num;
	char i, j;
	char _cantrig;
	#bit cantrig = _cantrig.0

	TSB3 = 0;
	TSB2 = 0; // RB2 as output
	RB2 = 0;
	TSB1 = 0;
	RB1 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	pwm_init(); // initialize CCP module
	servo_init();
	i2c_init();
	adc_init(0); // all channels analog, output MSBs

	GIE = 1;

	my_putc("ready\r");
	
	while (1) {
		inp = ser_rx(); // read from faster side
		my_putc(inp); // send to slower side
		delay_ms(1000); // wait
	}
}

