///////////////////////////////////////////////////////
//
// FileName: dbpid.c
// Author: kwanjee@andrew.cmu.edu
//
// PID on daughterboard
//
////////////////////////////////////////////////////////

//Timing settings

#include "16f877.h"

#include "877reg.h"
#include "sercomm.h"
#include "dbpwm.h"
#include "encupdn.h"

//#use delay(clock = 20000000)

//#define BLINK_PORT 	PORTB
//#define BLINK_PIN  	PORTB.0

#define	Kp 64
#define	Ki 24
#define	Kd 0

signed vel; // desired velocity
signed v; // instantaneous velocity
signed e; // error in velocity
signed pe; // previous error
signed de; // change in error over time
signed ie; // sum of error over time
signed pie; // previous sum of error
signed long Y; // PID output

// Timer2 overflows at 20kHz
// PID @ 300Hz == once every 65 overflows 
char pid_period = 64;
char t2_count = 0;
char pid_update = 0;

char modYl, modYh;
char sigY;

signed long modY;

char sat_add(char a, char b, char sub) {
	char res;
	
	if (sub) b = ~b + 1;

	res = a + b;

	if (!((a ^ b) & 0x80)) {
		if ((res ^ a) & 0x80) {
			if (res & 0x80) res = 0x7f;
			else res = 0x81;
		}
	}
	return res;
}

#INT_TIMER2
void tmr2intr(void) {

	// timer2 overflow
		
	// is it time to update PID?
	if (t2_count < pid_period) t2_count++;
	
	else {
		// update PID...
		t2_count = 0;
		
		// 16 bit signed arithmetic!!!!!

		v = enc_read();		
		enc_reset();
	
		// must saturate dv and d2v as well, 
		// else cannot handle large changes in vel
	
		pe = e;
		// e = vel - v;
		e = sat_add(vel,v,1);
	
		pie = ie;
		// ie = pie + e
		ie = sat_add(pie,e,0);
	
		//de = e - pe;
		de = sat_add(e,pe,1);
	
		Y = (signed long)Kp * e;
	
		Y = Y + (signed long)Ki * ie;
	
		Y = Y + (signed long)Kd * de;
			
		// saturate xh:xl to 10 bits magnitude
		// xh: chop off top 6 bits
		// if xh < 128, x is positive (sigY = 0)
		// else x is negative (sigY = 1, flip xl:xh)
		// at this point: xl:xh = magnitude. saturate it if necessary
		// if xh > 3, overflow, saturate
		// now, shift 2 bits right, setvel.
	
		if (Y > 1023) Y = 1023;
		if (Y < -1023) Y = -1023;
		if (Y > 0) {
			sigY = 0;
			modY = Y;
		}
		else {
			sigY = 1;
			modY = -Y;
		}
		
		modYh = modY >> 2;
		modYl = modY & 0xff;
		modYl = modYl << 6;
		
		pwm_setvel10(modYh,modYl,sigY);
		
		pid_update = 1;
	}	

	TMR2IF = 0; //interrupt handled.
}

void main(void) {
	char inp;
	char i;

	//OPTION_REG = 0x05; // TMR0 @ 1:64, prescaler to timer0 (pid loop freq)

	TRISB = 0; // port B as outputs
    TRISD = 0xff; // port D as inputs
    
    PORTB = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	pwm_init(); // initialize CCP module
	enc_init(); // initialize encoder counter chip	

	vel = 0;
	e = 0;
	de = 0;
	ie = 0;

	TMR2IE = 1;
	PEIE = 1;
	GIE = 1;

	ser_tx("\rDB PID\r");

	RB4 = 1;
	RB5 = 0;

	while (1) {
		ser_tx('>');
//		inp = ser_rx();
//		ser_tx(inp);
		inp = getdec();

//		vel = inp;

		for (i=0; i<100; i++) {
			if (i == 30) vel = inp;

			// wait for next pid update
			while (pid_update == 0);

			putdec(v); ser_tx(' ');
			putdec(e); ser_tx(' ');
			putdec(de); ser_tx(' ');
			putdec(ie); ser_tx(' ');
			puthex(Y >> 8); puthex(Y & 0xff); ser_tx(' ');
			puthex(sigY); ser_tx(' ');
			puthex(modYl); puthex(modYh); ser_tx('\r');
			
			pid_update = 0;
		}
	}
}

