///////////////////////////////////////////////////////
//
// FileName: db.h
// Author: kwanjee@andrew.cmu.edu
//
// Daughterboard interface routines
//
////////////////////////////////////////////////////////

#ifndef _DB_H_
#define _DB_H_

//#include <16f877.h>
#include "877reg.h"
#include "i2cm.h"

#define I2C_PREFIX 0xf8

char db_buf[10];
char db_buflen;

char db_off(char db_num);
char db_controller_off(char db_num);
char db_controller_on(char db_num);
char db_set_pwm(char db_num, char dir, char pwm);
char db_set_vel(char db_num, char vel);
char db_reset_disp(char db_num);
char db_set_consts(char db_num, char Kp, char Ki, char Kd);
char db_read_vel(char db_num);
char db_read_disp(char db_num);
char db_read_consts(char db_num);

// all functions return non-zero error codes

char db_tx_rx(char addr, char buflen) {
	char i;

	// turn db_num into i2c addr
	addr |= I2C_PREFIX;
		
	// transmit

	if (i2c_open(addr,I2C_WRITE)) {
		// nack, nobody home
		i2c_close();
		return 1;
	}

	//sw_putc('>');
	
	if (i2c_tx(db_buflen)) {
		i2c_close();
		i2c_reset();
		return 2;
	}
	
	for (i=0; i<db_buflen; i++) {
		if (i2c_tx(db_buf[i])) {
			i2c_close();
			i2c_reset();
			return 2;
		}
	}

	i2c_close();

	// receive
	
	if (i2c_open(addr,I2C_READ)) {
		i2c_close();
		return 3;
	}
	//sw_putc('<');
	
	i = i2c_rx(); // length byte
	i2c_nack(0);

	for (db_buflen=0; i>0; i--) {
		db_buf[db_buflen++] = i2c_rx();
		if (i == 1) i2c_nack(1);
		else i2c_nack(0);
		//sw_putc('.');
	}

	i2c_close(); // done with i2c...

	if (db_buflen != buflen) {
		// reply length wrong!
		sw_putc("expected "); sw_putdec(buflen); sw_putc(" got "); sw_putdec(db_buflen); sw_putc('\r');
		return 4;
	}

	return 0;	
}

// cmd: 0
char db_off(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 0;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 2
char db_controller_off(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 2;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 3
char db_controller_on(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 3;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 4
char db_set_pwm(char db_num, char dir, char pwm) {
	char ret;

	// setup tx data
	db_buf[0] = 4;
	db_buf[1] = dir;
	db_buf[2] = pwm;
	db_buflen = 3;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 5
char db_set_vel(char db_num, char vel) {
	char ret;

	// setup tx data
	db_buf[0] = 5;
	db_buf[1] = vel;
	db_buflen = 2;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 6
char db_reset_disp(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 6;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 8
char db_set_consts(char db_num, char Kp, char Ki, char Kd) {
	char ret;

	// setup tx data
	db_buf[0] = 8;
	db_buf[1] = Kp;
	db_buf[2] = Ki;
	db_buf[3] = Kd;
	db_buflen = 4;
	
	// tx
	ret = db_tx_rx(db_num, 1);
	
	return ret;
}

// cmd: 10
char db_read_vel(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 10;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 2);
	
	return ret;
}

// cmd: 11
char db_read_disp(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 11;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 3);
	
	return ret;
}

// cmd: 12
char db_read_consts(char db_num) {
	char ret;

	// setup tx data
	db_buf[0] = 12;
	db_buflen = 1;
	
	// tx
	ret = db_tx_rx(db_num, 4);
	
	return ret;
}
