///////////////////////////////////////////////////////
//
// FileName: b2bot.c
// Author: kwanjee@andrew.cmu.edu
//
// B2Bot, featuring find_red()
// now uses M packets
//
////////////////////////////////////////////////////////

#include <16f877.h>
#include "877reg.h"
#include "sercomm.h"
#include "sersoft.h"
#include "servo.h"
#include "adc.h"
#include "pwm.h"
#include "i2cm.h"

#define FIND_RED	0
#define TRACK_WIN	1

#define CENTERX 40
#define SERVOX	7
#define FWDVEL	230
#define TURNVEL	175

char buf[30];
char bp;

// camera parameters
char xpos;
char pxpos;
char size;
char conf;
signed char dx;

// color parameters
char rmin, rmax, gmin, gmax, bmin, bmax;

char putbuf(char p, char data) {
	char i;
	
	if (data >= 200)	{
		data -=	200;
		buf[p++] = '2';
	}
	if (data >= 100)	{
		data -=	100;
		buf[p++] = '1';
	}
	for	(i='0';	data > 9; i++) {
		data -=	10;
	}
	buf[p++] = i;
	buf[p++] = data + '0';
	
	return p;
}

void poll_mode(char mode) {
	// pre: camera has sent ':' and is ready for command
	char inp;
	
	do {
		ser_tx("pm ");
		ser_tx(mode + '0');
		ser_tx("\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');	
}

char find_red(void) {
	char i, inp;
	unsigned char rmin, rmax;
	unsigned char gbmin, gbmax;
	unsigned char x1, x2;
	
	// initial values
	rmin = 245;	rmax = 255;
	gbmin = 0;	gbmax = 10;
	
	do {
		ser_tx('\r');
		for (i=0; i<7; i++) {
			if ((inp = ser_rx()) == ':') break;
		}
	} while (inp != ':');
	
	poll_mode(1);

	for (rmin = 210; rmin > 160; rmin -= 10) {
		for (gbmax = 10; gbmax < 90; gbmax += 20) {
			// send tc
			buf[0]='t'; buf[1]='c'; buf[2]=' ';
			bp = putbuf(3,rmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,rmax);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmax);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmin);
			buf[bp++] = ' ';
			bp = putbuf(bp,gbmax);
			buf[bp++] = '\r';
			
			do {
				for (i=0; i<bp; i++) {
					ser_tx(buf[i]);
				}
				inp = ser_rx();
				while (ser_rx() != '\r');
			} while (inp != 'A');
			
			// get response
			if (ser_rx() != 255) {
				return 0;
			}
			if (ser_rx() != 'M') {
				return 0;
			}
			for (bp=0; bp<8; bp++) {
				buf[bp] = ser_rx();
			}
			if (ser_rx() != ':') {
				return 0; // recovery routine???
			}
			
			// interpret packet
			x1 = buf[0];
			//x2 = buf[2];
			size = buf[6];
			conf = buf[7];
			
			if ((x1 != 0)&&(conf < 50)) {
				// got it!
				poll_mode(0);
				return 1;
			}
		}
	}
	//my_putc('4');
	return 0;
	
}

char get_objx(void) {
	char inp, i;
	unsigned char x1, x2, x;
	
	bp = 0;
	// wait for delimiter
	do {
		while (ser_rx() != 255);
	} while (ser_rx() != 'M');
	
	for (bp=0; bp<8; bp++) {
		buf[bp] = ser_rx();
	}
			
	// interpret packet
	x = buf[0];
	size = buf[6];
	conf = buf[7];
	
	return x;
}

void move_camera(char x) {
	
	if (x == 0) {
/*		if (dx > 0) {
			xpos = xpos + 10;
		}
		else {
			xpos = xpos - 10;
		}
		if (xpos > 245) dx = 0;
		if (xpos < 10) dx = 1;*/
		//xpos = 115;
		return;
	}
	else {
		dx = CENTERX - x;
		//putdec(dx);
		pxpos = xpos;
		
		if (abs(dx) < 5) return;
		
		//if (x < CENTERX) {
		if (dx > 0) {
			// dx > 0
			xpos = xpos - (dx/2);
			
			// xpos decreases -> dx negative
			// x < CENTERX -> dx = x - CENTERX
	
			// dx is negative, it should decrease
			if (xpos > pxpos) xpos = 1; // saturate
		}
		//else if (x > CENTERX) {
		else if (dx < 0) {
			// dx < 0
			//dx = abs(dx);
			xpos = xpos + (abs(dx)/2);
			
			// dx is positive, it should increase
			if (xpos < pxpos) xpos = 255; // saturate
		}
	}
	
	servo_pos[SERVOX] = xpos;

	return;
}

// campos == 115 when centered
char turn_body(char campos, char x) {
	
	if (x == 0) {
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
		return 0;
	}
	
	// centered at 134
	if (campos > 144) {
		// camera facing left
		// turn left
		pwm_setvel8(0,1,TURNVEL);
		pwm_setvel8(1,0,TURNVEL);		
		return 1;
	}
	else if (campos < 124) {
		// camera facing right
		// turn right
		pwm_setvel8(0,0,TURNVEL);
		pwm_setvel8(1,1,TURNVEL);
		return 1;
	}
	else {
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
		return 0;
	}
}

void move_body(char size) {
	if (size < 2) {
		// too small, stop, ignore
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
		return;
	}
	else if (size < 60) {
		// too far, move towards
		pwm_setvel8(0,0,FWDVEL);
		pwm_setvel8(1,0,FWDVEL);		
	}
	else if (size > 100) {
		// too near, move away
		pwm_setvel8(0,1,FWDVEL);
		pwm_setvel8(1,1,FWDVEL);		
	}
	else {
		pwm_setvel8(0,0,0);
		pwm_setvel8(1,0,0);		
	}
	
	return;
}

void main(void) {
	char inp, num, x;
	char turning;
	char mode;

	TSB3 = 0;

	// init...
	ser_init(SER_115200); // init rs-232 comms
	sersoft_init(); // init software serial port
	servo_init();
	pwm_init();

	servo_state = 1; // activate servo driver

	GIE = 1;

	sw_putc("1 dof tracker\r");

	xpos = 134;
	servo_pos[SERVOX] = xpos;

	//my_getc();

	// get camera's attention
	do {
		ser_tx('\r');
		delay_ms(100);
		ser_tx("rs\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');
	sw_putc('@');

	do {
		ser_tx("rm 1\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("cr 19 32 18 32\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("nf 1\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	do {
		ser_tx("sw\r");
		// readback ACK\r
		inp = ser_rx();
		while (ser_rx() != ':');
	} while (inp != 'A');

	if (mode == TRACK_WIN) {
		delay_ms(2000);
		do {
			ser_tx("tw\r");
			// readback ACK\r
			inp = ser_rx();
			while (ser_rx() != ':');
		} while (inp != 'A');
	}
		
	sw_putc('#');

	x = 0;
	while (1) {
		if (mode == FIND_RED) {
			if (x = find_red()) {
				// found object, go into continuous tracking mode
				do {
					ser_tx("tc\r");
					inp = ser_rx();
					while (ser_rx() != '\r');
				} while (inp != 'A');
			}
			while (x != 0) {
				// keep tracking as long as object is found
				x = get_objx();
 				move_camera(x);
				turning = turn_body(xpos, x);
				if (!turning) move_body(size);
			}
		}
		else {
			// keep tracking as long as object is found
			x = get_objx();
			move_camera(x);
			turning = turn_body(xpos, x);
			if (!turning) move_body(size);
		}
	}

	/*while (1) {
		x = getdec();
		//turn_body(x);
		move_body(x);
	}*/
}
