/***************************************************************************/
/* Author: Alexander Gutierrez /alg2@andrew.cmu.edu                        */
/* Modified from Julian Winpenny's RS232.c/RS877.c code                                                                        */
/*                                                                         */
/***************************************************************************/

#include "16f877.h"

/*******************************/
/* Global Register assignments */
/*******************************/

/********************/
/* Flag Assignments */
/********************/

/*************************/
/* Bit Mask definitons   */
/*************************/

/******************************/
/* TxRxBitCount event numbers */
/* ( Transmit mode )          */
/******************************/

/********************************/
/* Port and system assignments  */
/********************************/

#pragma CLOCK_FREQ 20000000         // Set Internal Clock Speed

// USART Register bits

// TXSTA: Transmit Status and Control Register
#define CSCR 7
#define TX9  6
#define TXEN 5
#define SYNC 4
#define BRGH 2
#define TRMT 1
#define TX9D 0
// RCSTA: Recieve Status and Control Register
#define SPEN 7
#define RX9  6
#define SREN 5
#define CREN 4
#define ADDEN 3
#define FERR 2
#define OERR 1
#define RX9D 0  

#define TRMT_MASK 2

// Masks for PIR1

#define PSPIF_MASK 0x80
#define ADIF_MASK  0x40
#define RCIF_MASK  0x20  
#define TXIF_MASK  0x10

// Bits of PIR1

#define PSPIF  7
#define ADIF   6
#define RCIF   5 
#define TXIF   4
#define SSPIF  3
#define SSPIF_MASK 0x08
#define CCP1IF 2
#define TMR2IF 1
#define TMR1IF 0  

// Config Ports

#define PortAConfig  0x00           // All Outputs
#define PortBConfig  0xf0           // RB<7:4> Input
#define PortCConfig  0x98           // RC<7,4,2> Input
#define PortDConfig  0x00           // All Output
#define PortEConfig  0x00           // All Output

/***********************/
/* Function Prototypes */
/***********************/

void Setup(void);                   // Readies PIC for Serial Communication
void ConfigureComms(void)           // Configure the comms
void SendChar(char)                 // Send a character

char RxChars(void);                 // Recieve characters when RX Interrupt occurs

void SendString(const char *ptr );  //Send a const string


char MyFlags;

char BufferIndex;

char RxFifo[20];

#define RX_BUFFER_SIZE 20

#define BufferReady 0
#define BufferReadyMask 0x01

const char *Msg1 = "PIC16877 RS232 Test says Hello";

/***********************************************************************/
/*                       Start of MAIN                                 */
/***********************************************************************/


main ()
{
    Setup();                        //Run Setup Routine

    BufferIndex = 0;

    clear_bit( MyFlags, BufferReady );
    
    SendString( Msg1 );

}

/*******************************/
/* Setup Ports and Interrupts  */
/*******************************/
void Setup(void)
{
    set_bit( STATUS, RP0 );         // Register page 1

    //Initialize Registers
    TRISA = PortAConfig;
    TRISB = PortBConfig;
    TRISC = PortCConfig;
    TRISD = PortDConfig;
    TRISE = PortEConfig;

    clear_bit( STATUS, RP0 );       // Register page 0

    ConfigureComms();               /* Configure USART for Asyncronous Comms */

} //End Main

void interrupt(void)
{
        
 if ( ( PIR1 & RCIF_MASK ) != 0 ) // If USART RX Interrupt
    {
       RxChars();                // Process the received character
       clear_wdt();              
       clear_bit( PIR1, RCIF );  // Clear flag  
    }

// Return from Interrupt
}


/*******************************************************/
/* Configure USART for communications                  */
/*                                                     */
/* Asynchronous mode                                   */
/* 9,600 Baud  ( With 20 Mhz Clock )                  */
/* 8 data bits  ( For other rates see PIC16F8XX Data ) */
/* 2 stop bits                                         */
/* No Parity                                           */
/*                                                     */
/*******************************************************/
void ConfigureComms(void)
{
    set_bit( RCSTA, SPEN );    // Enable Serial port
    clear_bit( RCSTA, RX9 );   // 8 bit receive mode
        
    set_bit( STATUS, RP0 );    // *** Register page 1 ***
    
    clear_bit( TXSTA, TX9 );   // 8 bit transmit mode    
  
   // SPBRG = 20;              // SPBRG = 20  ( Set Baud rate 57,600 ) 
   // SPBRG = 36;              // SPBRG = 36  ( Set Baud rate 33,600 )
   // SPBRG = 42;              // SPBRG = 42  ( Set Baud rate 28,800 )
   // SPBRG = 64;              // SPBRG = 64  ( Set Baud rate 19,200 )
   // SPBRG = 129;             // SPBRG = 129 ( Set Baud rate  9,600 )
   
    SPBRG = 129;               // SPBRG = 129 ( Set Baud rate 9,600 )             
    
                               //------------------------------------------
                               //  For this value at a given clock rate 
                               //  see the microchip document           
                               //------------------------------------------                                
   
    set_bit( TXSTA, BRGH );    // BRGH = 1   ( High speed mode )
    clear_bit( TXSTA, SYNC );  // Asyncronous mode;
    
    set_bit( TXSTA, TXEN );    // Enable Transmitter
    
    set_bit( PIE1, RCIE );     // Enable Receive Interrupt
    
    clear_bit( STATUS, RP0 );  // *** Register page 0 ***
    
    set_bit( RCSTA, CREN );    // Enable continuous receive
    clear_bit( PIR1, RCIF );   // Clear Receive Interrupt flag

    set_bit( INTCON, PEIE );   // Enable all Peripheral Interrupts
    set_bit( INTCON, GIE );    // Enable Global Interrupts    
 
}

