///////////////////////////////////////////////////////
//
// FileName: four.c
// Author: Kwanjee Ng/kwanjee@andrew.cmu.edu
//
// Servo control, first attempt.
// Also contains ADC code packaged into function.
//
////////////////////////////////////////////////////////

//Timing settings
#pragma CLOCK_FREQ 20000000

#include "16f877.h"

#define BLINK_PORT PORTB
#define BLINK_PIN  1

#define SERVO_PORT PORTB
#define SERVO_PIN  0

char inval;
char led = 1;
char wait = 0;

// servo control variables
char servo_state = 0;
char servo_count = 0;

void interrupt(void) {

    clear_wdt();

	// this should roll over from 255 to 0.
    if( led<127 ) {
    	set_bit(PORTB, 1);
    }
    else {
        clear_bit(PORTB, 1);
    }
    led++;

	///////////////////////////////////////////////////////////
	// servo control, 1:32 prescaler on TMR0
	if (servo_state == 1) {
		// pre stage
		set_bit(SERVO_PORT,SERVO_PIN);
        //servo_count==0;
		servo_state = 2;
        TMR0 = 149; // == 256 - 107
	}
	else if (servo_state == 2) {
        // control hi stage
		servo_state = 3;
        TMR0 = inval;
	}
    else if (servo_state == 3) {
        // control lo stage
        servo_state = 4;
        clear_bit(SERVO_PORT,SERVO_PIN);
        TMR0 = 255 - inval;
    }
    else if (servo_state == 4) {
		// wait stage
        clear_bit(SERVO_PORT,SERVO_PIN);
		servo_count++;
		if (servo_count > 8) {
			// exit wait stage
			servo_state = 1;
            servo_count = 0;
		}
	}
	///////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////
	
    clear_bit( INTCON, T0IF );  //interrupt handled.
}

//
// Have to initialize ADC before using this function!!!
//
char ad_read(char ch) {

	ADCON0 = (ch << 3) & 56; // shift ch to correct bit position
	ADCON0 |= 0x81; // Tad = Fosc/32, ADC on.

	delay_us(12); // wait for Tacq
    
    ADCON0 |= 4; // acquire go!
	
    while (ADCON0 & 4); // wait for AD to complete

    delay_us(4); // wait for 2Tad
    
    return ADRESH; // return captured value
}

void main(void) {
    set_bit( STATUS, RP0 );
    OPTION_REG = 0x04; // set pre_scaler to 1:32
    TRISB = 0; // port B as outputs
    TRISD = 0; // prot D as outputs
	ADCON1 = 0x00; // port A all analog, result left justified
    
    clear_bit( STATUS, RP0 );
    PORTB = 0;
    PORTD = 0;

	// init...
    inval = 0; led = 0;
	
    enable_interrupt( GIE );
    enable_interrupt( T0IE );  //enable TMR0 overflow bit

    servo_state=1;
	while (1) {
        inval = ad_read(0); 
        PORTD = inval;
    }
}

