/*

PIC 16F877 Register file address definitions
Porting to CCS PICC compiler

*/

#nolist
#ifndef _877REG_H_
#define _877REG_H_

//#device PIC16F877

//Timing settings
#use delay(clock = 20000000)

// bank 0
#byte TMR0		= 0x01
#byte PCL		= 0x02
#byte STATUS	= 0x03
#byte FSR 		= 0x04
#byte PORTA		= 0x05
#byte PORTB		= 0x06
#byte PORTC		= 0x07
#byte PORTD		= 0x08
#byte PORTE		= 0x09
#byte PCLATH	= 0x0a
#byte INTCON	= 0x0b
#byte PIR1		= 0x0c
#byte PIR2		= 0x0d
#byte TMR1L		= 0x0e
#byte TMR1H		= 0x0f
#byte T1CON		= 0x10
#byte TMR2		= 0x11
#byte T2CON		= 0x12
#byte SSPBUF	= 0x13
#byte SSPCON	= 0x14
#byte CCPR1L	= 0x15
#byte CCPR1H	= 0x16
#byte CCP1CON	= 0x17
#byte RCSTA		= 0x18
#byte TXREG		= 0x19
#byte RCREG		= 0x1a
#byte CCPR2L	= 0x1b
#byte CCPR2H	= 0x1c
#byte CCP2CON	= 0x1d
#byte ADRESH	= 0x1e
#byte ADCON0	= 0x1f

// bank 1
#byte OPTION_REG= 0x81
#byte TRISA		= 0x85	
#byte TRISB		= 0x86
#byte TRISC		= 0x87
#byte TRISD		= 0x88
#byte TRISE		= 0x89
#byte PIE1		= 0x8c
#byte PIE2		= 0x8d
#byte PCON		= 0x8e
#byte SSPCON2	= 0x91
#byte PR2		= 0x92
#byte SSPADD	= 0x93
#byte SSPSTAT	= 0x94
#byte TXSTA		= 0x98
#byte SPBRG		= 0x99
#byte ADRESL	= 0x9e
#byte ADCON1	= 0x9f

// BANK2
#byte EEDATA	= 0x10c
#byte EEADR		= 0x10d
#byte EEDATH	= 0x10e
#byte EEADRH	= 0x10f

//BANK3
#byte EECON1	= 0x18c
#byte EECON2	= 0x18d

#bit IRP		= STATUS.7
#bit RP1		= STATUS.6
#bit RP0		= STATUS.5
#bit TO			= STATUS.4
#bit PD			= STATUS.3
#bit ZERO		= STATUS.2
#bit DC			= STATUS.1
#bit CARRY		= STATUS.0

#bit RA7		= PORTA.7
#bit RA6		= PORTA.6
#bit RA5		= PORTA.5
#bit RA4		= PORTA.4
#bit RA3		= PORTA.3
#bit RA2		= PORTA.2
#bit RA1		= PORTA.1
#bit RA0		= PORTA.0

#bit RB7		= PORTB.7
#bit RB6		= PORTB.6
#bit RB5		= PORTB.5
#bit RB4		= PORTB.4
#bit RB3		= PORTB.3
#bit RB2		= PORTB.2
#bit RB1		= PORTB.1
#bit RB0		= PORTB.0

#bit RC7		= PORTC.7
#bit RC6		= PORTC.6
#bit RC5		= PORTC.5
#bit RC4		= PORTC.4
#bit RC3		= PORTC.3
#bit RC2		= PORTC.2
#bit RC1		= PORTC.1
#bit RC0		= PORTC.0

#bit RD7		= PORTD.7
#bit RD6		= PORTD.6
#bit RD5		= PORTD.5
#bit RD4		= PORTD.4
#bit RD3		= PORTD.3
#bit RD2		= PORTD.2
#bit RD1		= PORTD.1
#bit RD0		= PORTD.0

#bit RE2		= PORTE.2
#bit RE1		= PORTE.1
#bit RE0		= PORTE.0

#bit GIE		= INTCON.7
#bit PEIE		= INTCON.6
#bit T0IE		= INTCON.5
#bit INTE		= INTCON.4
#bit RBIE		= INTCON.3
#bit T0IF		= INTCON.2
#bit INTF		= INTCON.1
#bit RBIF		= INTCON.0

#bit PSPIF		= PIR1.7
#bit ADIF		= PIR1.6
#bit RCIF		= PIR1.5
#bit TXIF		= PIR1.4
#bit SSPIF		= PIR1.3
#bit CCP1IF		= PIR1.2
#bit TMR2IF		= PIR1.1
#bit TMR1IF		= PIR1.0

#bit EEIF		= PIR2.4
#bit BCLIF		= PIR2.3
#bit CCP2IF		= PIR2.0

#bit T1CKPS1	= T1CON.5
#bit T1CKPS0	= T1CON.4
#bit T1OSCEN	= T1CON.3
#bit T1SYNC		= T1CON.2
#bit TMR1CS		= T1CON.1
#bit TMR1ON		= T1CON.0

#bit TOUTPS3	= T2CON.6
#bit TOUTPS2	= T2CON.5
#bit TOUTPS1	= T2CON.4
#bit TOUTPS0	= T2CON.3
#bit TMR2ON		= T2CON.2
#bit T2CKPS1	= T2CON.1
#bit T2CKPS0	= T2CON.0

#bit WCOL		= SSPCON.7
#bit SSPOV		= SSPCON.6
#bit SSPEN		= SSPCON.5
#bit CKP		= SSPCON.4
#bit SSPM3		= SSPCON.3
#bit SSPM2		= SSPCON.2
#bit SSPM1		= SSPCON.1
#bit SSPM0		= SSPCON.0

#bit CCP1X		= CCP1CON.5
#bit CCP1Y		= CCP1CON.4
#bit CCP1M3		= CCP1CON.3
#bit CCP1M2		= CCP1CON.2
#bit CCP1M1		= CCP1CON.1
#bit CCP1M0		= CCP1CON.0

#bit SPEN		= RCSTA.7
#bit RX9		= RCSTA.6
#bit SREN		= RCSTA.5
#bit CREN		= RCSTA.4
#bit ADDEN		= RCSTA.3
#bit FERR		= RCSTA.2
#bit OERR		= RCSTA.1
#bit RX9D		= RCSTA.0

#bit CCP2X		= CCP2CON.5
#bit CCP2Y		= CCP2CON.4
#bit CCP2M3		= CCP2CON.3
#bit CCP2M2		= CCP2CON.2
#bit CCP2M1		= CCP2CON.1
#bit CCP2M0		= CCP2CON.0

#bit ADCS1		= ADCON0.7
#bit ADCS0		= ADCON0.6
#bit CHS2		= ADCON0.5
#bit CHS1		= ADCON0.4
#bit CHS0		= ADCON0.3
#bit GO			= ADCON0.2
#bit ADON		= ADCON0.0

#bit RBPU		= OPTION_REG.7
#bit INTEDG		= OPTION_REG.6
#bit T0CS		= OPTION_REG.5
#bit T0SE		= OPTION_REG.4
#bit PSA		= OPTION_REG.3
#bit PS2		= OPTION_REG.2
#bit PS1		= OPTION_REG.1
#bit PS0		= OPTION_REG.0

#bit TSA7		= TRISA.7
#bit TSA6		= TRISA.6
#bit TSA5		= TRISA.5
#bit TSA4		= TRISA.4
#bit TSA3		= TRISA.3
#bit TSA2		= TRISA.2
#bit TSA1		= TRISA.1
#bit TSA0		= TRISA.0

#bit TSB7		= TRISB.7
#bit TSB6		= TRISB.6
#bit TSB5		= TRISB.5
#bit TSB4		= TRISB.4
#bit TSB3		= TRISB.3
#bit TSB2		= TRISB.2
#bit TSB1		= TRISB.1
#bit TSB0		= TRISB.0

#bit TSC7		= TRISC.7
#bit TSC6		= TRISC.6
#bit TSC5		= TRISC.5
#bit TSC4		= TRISC.4
#bit TSC3		= TRISC.3
#bit TSC2		= TRISC.2
#bit TSC1		= TRISC.1
#bit TSC0		= TRISC.0

#bit TSD7		= TRISD.7
#bit TSD6		= TRISD.6
#bit TSD5		= TRISD.5
#bit TSD4		= TRISD.4
#bit TSD3		= TRISD.3
#bit TSD2		= TRISD.2
#bit TSD1		= TRISD.1
#bit TSD0		= TRISD.0

#bit IBF		= TRISE.7
#bit OBF		= TRISE.6
#bit IBOV		= TRISE.5
#bit PSPMODE	= TRISE.4
#bit TSE2		= TRISE.2
#bit TSE1		= TRISE.1
#bit TSE0		= TRISE.0

#bit PSPIE		= PIE1.7
#bit ADIE		= PIE1.6
#bit RCIE		= PIE1.5
#bit TXIE		= PIE1.4
#bit SSPIE		= PIE1.3
#bit CCP1IE		= PIE1.2
#bit TMR2IE		= PIE1.1
#bit TMR1IE		= PIE1.0

#bit EEIE		= PIE2.4
#bit BCLIE		= PIE2.3
#bit CCP2IE		= PIE2.0

#bit POR		= PCON.1
#bit BOR		= PCON.0

#bit GCEN		= SSPCON2.7
#bit ACKSTAT	= SSPCON2.6
#bit ACKDT		= SSPCON2.5
#bit ACKEN		= SSPCON2.4
#bit RCEN		= SSPCON2.3
#bit PEN		= SSPCON2.2
#bit RSEN		= SSPCON2.1
#bit SEN		= SSPCON2.0

#bit SMP		= SSPSTAT.7
#bit CKE		= SSPSTAT.6
#bit DA			= SSPSTAT.5
#bit STOP		= SSPSTAT.4
#bit START		= SSPSTAT.3
#bit RW			= SSPSTAT.2
#bit UA			= SSPSTAT.1
#bit BF			= SSPSTAT.0

#bit CSRC		= TXSTA.7
#bit TX9		= TXSTA.6
#bit TXEN		= TXSTA.5
#bit SYNC		= TXSTA.4
#bit BRGH		= TXSTA.2
#bit TRMT		= TXSTA.1
#bit TX9D		= TXSTA.0

#bit ADFM		= ADCON1.7
#bit PCFG3		= ADCON1.3
#bit PCFG2		= ADCON1.2
#bit PCFG1		= ADCON1.1
#bit PCFG0		= ADCON1.0

#bit EEPGD		= EECON1.7
#bit WRERR		= EECON1.3
#bit WREN		= EECON1.2
#bit WR			= EECON1.1
#bit RD			= EECON1.0

#endif
#list