/*
 * TurnHeadAction.java
 *
 * Created on January 24, 2003, 9:42 AM
 */

package PER.rover;

/**
 *
 * @author  Rachel Gockley
 */
public class TurnHeadAction implements Action {
    private int pan, tilt;
    private boolean success;
    private transient Thread myThread;
    
    /** Creates a new instance of TurnHeadAction */
    public TurnHeadAction() {
        pan = tilt = 0;
        success = false;
        myThread = null;
    }
    
    public TurnHeadAction(int p, int t) {
        pan = p;
        tilt = t;
        success = false;
    }
    
    /**
     * Tries to start the action. Returns whether the action started. Should NOT BLOCK
     * on actions that involve motion!
     */
    public boolean doAction(Rover trike) {
        PER.rover.StatsLog.println(PER.rover.StatsLog.TURN_HEAD);
        success = false;
        final Rover t = trike;
        
        myThread = new Thread() {
            public void run() {
                // try up to five times before giving up
                for (int cnt = 0; cnt < 5 && !success; cnt++)
                    success = t.MoveHeadTo(pan, tilt);
                
                try { Thread.sleep(500); } catch (Exception e) {}
            }
        };
        
        myThread.start();
        Thread.yield();
        return true;
    }
    
    /** The return value of the Action. 0 is a success. Negative implies one
     * of this class's constants. Other values should be interpreted as
     * appropriate.
     */
    public int getReturnValue() {
        if (success)
            return 0;
        else{
            return ActionConstants.COMM_DEAD;
        }
    }
    
    /** Provides a shortened version of the summary returned by getSummary. For
     * example, getSummary may return something like "Turn left and drive about
     * 39 inches toward the red landmark," whereas getShortSummary might just
     * return "Drive toward a landmark."
     */
    public String getShortSummary() {
        return "Move the head.";
    }
    
    /** Provides a textual explanation of the Action, such as "turn 90 degrees"  */
    public String getSummary() {
        return "Pan the head to " + pan + " degrees, and tilt to " + tilt + " degrees.";
    }
    
    /** How long the action will take, in seconds.  */
    public int getTime() {
        return 1;
    }
    
    /** Whether the action has completed. Undefined until doAction has been called.
     */
    public boolean isCompleted() {
        return (myThread != null && !myThread.isAlive());
    }
    
    /** Whether the action completed successfully. Undefined until isCompleted() returns
     * true.
     */
    public boolean isSuccess() {
        return success;
    }
    
    /** Emergency stop - end the action immediately, if it's running.
     */
    public void kill() {
        // nothing to do!
    }
    
    public void setPan(int p) {
        pan = p;
    }
    
    public void setTilt(int t) {
        tilt = t;
    }
    
    /** How much time until the action finishes (in seconds), if it has already
     * started. Undefined behavior if the action has not yet begun, or has finished.
     */
    public int getTimeRemaining() {
        return 0;
    }
}
