package PER.rover;

/*
 * SendEmailAction.java
 *
 * Created on December 3, 2002, 4:28 PM
 */

import java.io.*;
import sun.net.smtp.SmtpClient;

/**
 *
 * @author  Rachel Gockley
 */
public class SendEmailAction implements Action {
    transient private SmtpClient smtp;
    private String mailto;
    private String subject;
    private String message;
    
    private String mailfrom = "donotreply@cmu.edu";
    private String mailfromName = "Rover";
    private String serverName = "smtp.andrew.cmu.edu";

    private boolean messageSent;
    
    /** Creates a new instance of MailMessage */
    public SendEmailAction() {
        mailto = "";
        subject = "Message from " + mailfromName + "!";
        message = "";
        messageSent = false;
    }

    public SendEmailAction(String recip, String msg) {
        super();
        mailto = recip;
        message = msg;
    }
    
    public SendEmailAction(String recip, String msg, String subj) {
        super();
        mailto = recip;
        message = msg;
        subject = subj;
    }

    public void setRecipient(String recip) {
        mailto = recip;
    }
    
    public void setMessage(String msg) {
        message = msg;
    }
    
    public void setSubject(String subj) {
        subject = subj;
    }

    public void setServer(String SMTP) {
        serverName = SMTP;
    }

    public void setFrom(String roverName) {
        mailfromName = roverName;
    }
    
    public boolean doAction(Rover r) {
        PER.rover.StatsLog.println(PER.rover.StatsLog.SEND_EMAIL); 
        try {
            smtp = new SmtpClient(serverName);

            // Sets the originating e-mail address
            smtp.from(mailfrom);
            
            // Sets the recipients' e-mail address
            smtp.to(mailto);
            
            // Create an output stream to the connection
            PrintStream msg = smtp.startMessage();
            
            msg.println("To: " + mailto); // so mailers will display the recipient's e-mail address
            msg.println("From: " + mailfromName + " <" + mailfrom + ">"); // so that mailers will display the sender's e-mail address
            msg.println("Subject: " + subject);
            msg.println(message);
            
            // Close the connection to the SMTP server and send the message out to the recipient
            smtp.closeServer();
            
            messageSent = true;
            return true;
        } catch (IOException e) {
            messageSent = false;
            return false;
        }
    }    
    
    /** The return value of the Action. 0 is a success. Negative implies one
     * of this class's constants. Other values should be interpreted as
     * appropriate.
     */
    public int getReturnValue() {
        if (messageSent)
            return 0;
        else{
            return ActionConstants.SMTP_FAILED;
        }
    }
    
    /** Provides a shortened version of the summary returned by getSummary. For
     * example, getSummary may return something like "Turn left and drive about
     * 39 inches toward the red landmark," whereas getShortSummary might just
     * return "Drive toward a landmark."
     */
    public String getShortSummary() {
        return "Send an email.";
    }
    
    /** Provides a textual explanation of the Action, such as "turn 90 degrees"  */
    public String getSummary() {
        return "Send an email to <" + mailto + ">, with subject \"" + subject + "\".";
    }
    
    /** How long the action will take, in seconds.  */
    public int getTime() {
        return 0;
    }
    
    /** Whether the action completed successfully. Undefined until doAction has
     * been called.
     */
    public boolean isSuccess() {
        return messageSent;
    }
    
    /** Whether the action has completed. Undefined until doAction has been called.
     */
    public boolean isCompleted() {
        return true;
    }
    
    /** Emergency stop - end the action immediately, if it's running.
     */
    public void kill() {
    }
    
    /** How much time until the action finishes (in seconds), if it has already
     * started. Undefined behavior if the action has not yet begun, or has finished.
     */
    public int getTimeRemaining() {
        return 0;
    }
    
}
